/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorlistdialog.cpp
*/
#include "colorlistdialog.h"
#include "colorlistdialog.moc"




ColorListWidget::ColorListWidget(QWidget *parent,colorList *c) :
	QWidget(parent,"ColorlistWidget")
{

int x;
textureBase *tb;
QWidget *w;

	co=c;

	empty=NULL;


	line=new QLineEdit(this);
	line->setText(co->getName());
	n=new QLabel("Name:",this);

	combobox=new QComboBox(this);
	combobox->insertItem("Brick");
	combobox->insertItem("Checker");
	combobox->insertItem("Hexagon");
	combobox->setCurrentItem((int)co->getColorListFunction());
	l=new QLabel("Pattern:",this);

	tab=new TabWidget(this,"Color:",1);

	tb=co->getFirstElement();
	while (tb!=NULL) {

		switch(tb->getType()) {
			case COLOR:
				w=(QWidget *)new ColorWidget(NULL,(color *)tb);
	     			colorwidget.append( (ColorWidget *)w );
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName() );

			break;
			default:
			break;
		}
         	tb=co->getNextElement();
	}



	if (colorwidget.length()==0) empty=new QLabel("no colors in list ! ",this);	
	active=new QCheckBox("Active",this);
	active->setChecked(co->active() );

	add=new QPushButton("Add Element",this);
	connect(add,SIGNAL(clicked()),this,SLOT(addClicked()) );

	resize(200,300);
	
}

void ColorListWidget::addClicked()
{
color *c=new color( co);
QWidget *w;
int x;
	if (empty) {
		delete tab;
		tab=new TabWidget(this,"Color:",1);
		tab->setGeometry(10,105,290,150);
		tab->show();
		delete empty;
		empty=NULL;
	}
        co->add(c);
	w=(QWidget *)new ColorWidget(NULL,(color *)c);
	colorwidget.append( (ColorWidget *)w );
	widgetlist.append (w);
	x=widgetlist.length()-1;
	tab->addWidget(w,x,c->getName() );
        tab->select(x);
}

ColorListWidget::~ColorListWidget()
{
}


void ColorListWidget::getColorList()
{
int i;
	co->setName( (char *)line->text());
	for (i=0;i<colorwidget.length();i++) if (colorwidget[i]) colorwidget[i]->getColor();	
	switch(combobox->currentItem()) {
		case 0: 
			co->setColorListFunction((colorList::FUNCTION)0);
		break;
		case 1: 
			co->setColorListFunction((colorList::FUNCTION)1);
		break;
		case 2: 
			co->setColorListFunction((colorList::FUNCTION)2);
		break;
	}

}

int ColorListWidget::width()
{
	return 280;
}

int ColorListWidget::height()
{
	return 290;
}

void ColorListWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	//int h=height();
	
	add->setGeometry(10,40,110,25);

	n->setGeometry(10,10,50,25);
	line->setGeometry(65,10,150,25);

	active->setGeometry(220,10,60,25);
	
	l->setGeometry(w/2-60-50,75,70,25);
	combobox->setGeometry(w/2-40,75,80,25);	

	if (empty) {
		empty->setGeometry(10,110,100,25);
		tab->setGeometry(-400,-190,320,180);		
	}
	else tab->setGeometry(10,105,290,150);
	
	QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

ColorListDialog::ColorListDialog(QWidget *parent,colorList *cl) :
	QDialog(parent,"ColorListDialog",true)
{

	setCaption("Colorlist");

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new ColorListWidget(this,cl);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(300,300);
	setMinimumSize(300,300);
	setMaximumSize(300,300);
	
}

ColorListDialog::~ColorListDialog()
{
}


void ColorListDialog::cancelPressed()
{
	QDialog::done(0);
}

void ColorListDialog::okayPressed()
{
	pw->getColorList();
	QDialog::done(1);
}

void ColorListDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}



