/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** viewwidget.h
*/
#ifndef __VIEWWIDGET_H__
#define __VIEWWIDGET_H__

#include <qwidget.h>
#include <qframe.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtimer.h>

#include <kprocess.h>
#include <view.h>


class ViewWidget : public QFrame, public view
{
Q_OBJECT
protected:

	QColor		backcolor,drawcolor,selcolor,boxcolor,gridcolor;
	QColor		blobcolor,xaxecolor,yaxecolor,zaxecolor;
	QColor		letterxcolor,letterycolor,letterzcolor;
	QPainter	*qp;
	QPixmap		*qpm;	// double buffer
	int		viewmode,axemode;
	int		xo,yo;

	KProcess	proc;
	FILE		*ppmfp;
	int		x,y;

	int		tcounter;
 	int		lc;

	int		gridlines_xy;
	int		gridlines_xz;
	int		gridlines_zy;
	int		gridpoints_xy;
	int		gridpoints_xz;
	int		gridpoints_zy;
	double		gridspace_xy;
	double		gridspace_xz;
	double		gridspace_zy;
	int		grid_xy;
	int		grid_xz;
	int		grid_zy;

public:
	ViewWidget(QWidget *p,const char *name,world*);
	~ViewWidget();



	int		drawLine(Vector3,Vector3,Matrix44,int,QColor);
	int		drawLine(Vector3,Vector3,Matrix44,int);
	int		drawCross(Vector3,Matrix44,int);
	int		drawTriangle(Vector3,Vector3,Vector3,Matrix44,int);
	int		drawTrapezium(Vector3,Vector3,Vector3,Matrix44,int);
	int		drawCircle(Vector3,Vector3,Vector3,Matrix44,int);
	int		drawSemiCircle(Vector3,Vector3,Vector3,Matrix44,int);
	int		drawSymbol(Vector3,const char *,Matrix44,int);

	int		drawSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	int		drawSemiSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	int		drawBox(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	int		drawCone(Vector3,Vector3,Vector3,Vector3,double,Matrix44,int);
	int		drawCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	int		drawTorus(Vector3,Vector3,Vector3,Vector3,double,Matrix44,int);

	int		drawBlobSphere(Vector3,Vector3,Vector3,Vector3,Matrix44,int);
	int		drawBlobCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44,int);

	int		drawIcon(Vector3,QPixmap,int,int,Matrix44,int);

	int		drawAxis(Matrix44,int);
	int		drawDragvector(Matrix44,Vector3,Vector3,int);

protected:
	virtual void	paintEvent(QPaintEvent*);
	void		mouseMoveEvent(QMouseEvent*);
	void		mousePressEvent(QMouseEvent*);

	void		timerEvent(QTimerEvent*);

signals:

	void		selected(const char *name);
	void		exportPOV(const char *name);
	void		resizedView(int,int);
	void		report(QString);

public slots:

	void		draw(int);
	void		draw();
	void		drawanim();

	void		setWorld(world *);

	void		configure();
	void		reconfigure();

	void		rotateView(double,double,double);
	void		rotate0View(double,double,double);
	void		moveView(double,double,double);
	void		changeFOV(double);

	void		setViewMode(int);
	void		setProjectionMode(int);
	int		projectionMode();
	void		setAxeMode(int);

	void		setSelected(base *bp);

	void		flush();

	void		startRendering(int q=11);
	void		stopRendering();
	
	int		setName(const char*);

protected:

	void		setColor(int )
	{
		qp->setPen(drawcolor);
	}

};


#endif

