/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** animwidget.h
*/
#ifndef __ANIMWIDGET_H__
#define __ANIMWIDGET_H__

//#include <qslider.h>
class QSlider;

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include <kprocess.h>

#include <world.h>

#include "comm.h"

	
class AnimControlWidget : public  QWidget
{
Q_OBJECT
protected:

	world		*_world,*worldtmp;

	QSlider		*timeslider;
	QLabel		*llabel,*rlabel;
	QPushButton	*playbt,*stopbt,*pausebt,*ffbt,*fbbt,*stepbt;
	QLineEdit	*starttime,*endtime;
	QLabel		*timelabel;
	QLineEdit	*stepvalue;
	QLabel		*steplabel;
	QCheckBox	*step_or_n;
	QLabel		*exportlabel;
	QLineEdit	*exportform;
	QCheckBox	*exportpov;

	int		lvalue,rvalue,stepsize,now;
	int		running;
	Comm		*c;

public:

	AnimControlWidget(QWidget *parent=0,char *name=0);
	~AnimControlWidget();

	world	*getWorld();

	void	layout();
	
	void	hide();
	void	show();

protected:
	virtual void	paintEvent(QPaintEvent*);

protected slots:
	void		changedStepsize(int);
	void		changedStepsize(const char*);
	void		changedInterval(int,int);
	void		changedLValue(const char*);
	void		changedRValue(const char*);

	void		timerEvent(QTimerEvent*);

public slots:
	void		startPressed();
	void		stopPressed();

	void		setWorld(world*);

signals:
	void		changeWorld(world*);
	void		redraw();
	void		drawanim();
	void		exportPOV(const char*);
	void		exportPOVanim(const char*);
};


#endif


