/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normalmap.cpp
*/
#include "normalmap.h"

#include <misc.h>

static char	fnname[normalMap::NFunctions][20] =
		{
			"checker",
			"marble",
			"wood",
			"granite",
			"leopard",
			"onion",
			"brick",
			"hexagon",
			"agate",
			"average",
			"crackle",
			"dents",
			"mandel",
			"waves",
			"spotted",
			"ripples",
			"gradient",
			"radial",
			"spiral1",
			"spiral2",
			"bozo",
			"bumps",
			"wrinkles",
		};

normalMap::normalMap():chunk()
{
	fn=Agate;
	normalEntryList.append( new normalEntry(0.3,new normal() ) );
	normalEntryList.append( new normalEntry(0.8,new normal() ) );
}

void normalMap::clearNormalMap()
{
	normalEntryList.empty();	
}

void normalMap::sortNormalMap()
{
int a,i,j;
normalEntry *pe;
	#ifdef DEBUG
		printf("sorting normalMap\n");
	#endif
	a=normalEntryList.length();
	for (i=2;i<a;i++) {
		for (j=a;j>i;j--) {
			if ( normalEntryList[j-1]->getNormalRange()>normalEntryList[j]->getNormalRange() ) {
				pe=normalEntryList.at( (long)j-1);
				normalEntryList[j-1]=normalEntryList[j];
				normalEntryList.at(j)=pe;
			}
		}
	}
	#ifdef DEBUG
		printf("NormalMap sorted\n");
	#endif
}

void normalMap::addNormalMapEntry(double v, normal *p)
{
	normalEntryList.insert( new normalEntry(v,p) );
}

void normalMap::deleteNormalMapEntry(int n)
{
	normalEntryList.deleteAt(n);
}

normalEntry *normalMap::getNormalMapEntry(int n)
{
	return normalEntryList.at(n);
}

normalMap::~normalMap()
{
}

void normalMap::setNormalMapFunction(FUNCTION f)
{
	fn=f;
}

int normalMap::getNormalMapFunction()
{
	return fn;
}

char *normalMap::getNormalMapFunctionName()
{
	return fnname[fn];
}

char *normalMap::getNormalMapFunctionNameList(int n)
{
	return fnname[n];
}

int	normalMap::load(media*m,int l)
{
	int x,i;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	i=0;

	setMedia(m);

	#ifdef DEBUG
		printf("loading normalMap\n");
	#endif

	m->read(&fn,4);
	m->read(&x,4);
	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"NRME",4) == 0) {
			addNormalMapEntry(0,new normal() );
			getNormalMapEntry(i)->load(m,len);
			read=true;
			i++;
		}
		if(strncmp(chunk,"MAPM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("NormalMap loaded\n");
	#endif
	return 0;
}

int	normalMap::save(media *m)
{
int i;
	if(!m) return -1;

	#ifdef DEBUG
		printf("saving normalMap\n");
	#endif

	setMedia(m);
	
	writeChunk("PIGM");

	SI(fn);
	SI(normalEntryList.length());
	for (i=0;i<normalEntryList.length();i++)  {
		normalEntryList[i]->save(m);			
	}
	modifier.save(m);
	writeChunkLen();
	#ifdef DEBUG
		printf("NormalMap saved\n");
	#endif
	return 0;
}

int normalMap::exportPOV(FILE *fp,int tab,int tabsize,int a)
{
int i;
	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting normalMap (POV)\n");
	#endif
	printTab(fp,tab);
	fprintf(fp,"%s\n",getNormalMapFunctionName() );

	printTab(fp,tab);
	fprintf(fp,"normal_map {\n" );	


	normalEntryList.getFirst()->exportPOV(fp,tab+tabsize,tabsize,a);
	for (i=1;i<normalEntryList.length();i++)  {
		normalEntryList[i]->exportPOV(fp,tab+tabsize,tabsize,a);			
	}
	modifier.exportPOV(fp,tab,tabsize,a,false);
	printTab(fp,tab);
	fprintf(fp,"}\n" );	
	#ifdef DEBUG
		printf("NormalMap exported (POV)\n");
	#endif
	return 0;
}

