/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normallist.h
*/
#ifndef __NORMALLIST_H__
#define __NORMALLIST_H__

#include <chunk.h>
#include <list.h>
#include "normal.h"


class normalEntry;
class normal;

class normalList : public virtual chunk
{
public:
	enum FUNCTION
	{	Brick,
		Checker,
		Hexagon,
		NFunctions
	};
	
	normalList();
	~normalList();

	void 	setNormalListFunction(FUNCTION f);
	int 	getNormalListFunction();
	
	void	addNormalListEntry(normal *);
	void	deleteNormalListEntry(int);
	void	clearNormalList();	

	normal	*getNormalListEntry(int);

	char 	*getNormalListFunctionName();
	char 	*getNormalListFunctionNameList(int);

	int	load(media *,int);
	int	save(media *);
	int	exportPOV(FILE*,int,int,int);

protected:
	FUNCTION	fn;
	list<normal *>		normals;

};


#endif


