/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** superellipsoid.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "superellipsoid.h"
#include "num.h"

superellipsoid::superellipsoid(base *p,char *na,double a, double b) :
	csgobj(p,na)
{
	numtype = NUM_SUPERELLIPSOID;
	e=a;n=b;
	if(parent) addToParent(parent);
}

superellipsoid::~superellipsoid()
{
}

int	superellipsoid::addToParent(base *p)
{
	if(!p) return -2;

	return p->addChild(this);
}

int     superellipsoid::exportPOV(FILE *fp,int tab,int tabsize,int anim) 
{ 
	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = superellipsoid\n");

	printTab(fp,tab);
	fprintf(fp,"sphere\n");
	printTab(fp,tab);
	fprintf(fp,"{\n");
	printTab(fp,tab + tabsize);
	fprintf(fp,"<%f, %f> \n",e,n);
	
	dim::exportPOV(fp,tab + tabsize,tabsize,anim);
	
	printTab(fp,tab); 
	fprintf(fp,"}\n\n");

	return 0;
}

void	superellipsoid::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("superellipsoid: %s\n",name); 
}


int	superellipsoid::save(FILE *fp)
{
	if(!fp) return -1;

	setFile(fp);
	writeChunk("SELL");
	SN(name);

	saveFlags(fp);

	SD(e);
	SD(n);

	anim::save(fp);
	dim::save(fp);

	writeChunkLen();

	return 0;
}

int	superellipsoid::load(FILE *fp,int l)
{
	int	pos = ftell(fp);

	loadFlags(fp,l);

	e = readDouble(fp);
	n = readDouble(fp);

	anim::load(fp,l - (ftell(fp) - pos));
	dim::load(fp,l - (ftell(fp) - pos));

	return 0;
}




