/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** dragvector.h
*/
#ifndef __DRAGVECTOR_H__
#define __DRAGVECTOR_H__

#include <list.h>
#include <misc.h>
#include <matmath.h>


class dragvector
{
public:
	typedef enum
	{
		DEFAULT = 0,
		MODIFY_LENGTH,
		NO_DIRECTION,
	}
	DRAG_USE;

protected:
	Vector3		d_direction,d_position;
	DRAG_USE	flags;

	Vector3		*vecmod;
	double		*xmod,*ymod,*zmod;

	double		d_multiplier;

public:
	dragvector(Vector3,Vector3*,double mul = 1);
	dragvector(Vector3,double*,double* y = 0,double* z = 0,double mul = 1);

	void		setDirection(Vector3);
	void		setPosition(Vector3);
	void		setGeometry(Vector3,Vector3);

	Vector3		direction();
	Vector3		position();

	int		isFlag(DRAG_USE);
	void		setFlag(DRAG_USE,int set = 1);

	double		multiplier();
	void		setMultiplier(double);

	void		multiply(Vector3);
	void		add(Vector3);

private:
	void		multiplyX(Vector3);
	void		multiplyY(Vector3);
	void		multiplyZ(Vector3);
	void		multiplyVector(Vector3);

	void		addX(Vector3);
	void		addY(Vector3);
	void		addZ(Vector3);
	void		addVector(Vector3);

	void		modifyLength();
};

#endif


