//-----------------------------------------------------------------------------
//
// kneri - port of "neri" from xlock
//

#ifndef __NERI_H__
#define __NERI_H__

#include <qtimer.h>
#include <qlist.h>
#include <qdialog.h>
#include <qlined.h>
#include "saver.h"

class kNeriSaver : public kScreenSaver
{
	Q_OBJECT
public:
	kNeriSaver( Drawable drawable );
	virtual ~kNeriSaver();

	void setSpeed( int spd );
	void setLevels( int l );

protected:
	void readSettings();

protected slots:
	void slotTimeout();

protected:
	QTimer      timer;
	int         colorContext;

	int         speed;
	int			maxLevels;
};

class kNeriSetup : public QDialog
{
	Q_OBJECT
public:
	kNeriSetup( QWidget *parent = NULL, const char *name = NULL );

protected:
	void readSettings();

private slots:
	void slotSpeed( int );
	void slotLevels( int );
	void slotOkPressed();
	void slotAbout();

private:
	QWidget *preview;
	kNeriSaver *saver;

	int			speed;
	int			maxLevels;
};

#endif

