/***************************************************************************
    kontroll1.h  fr  KWA - Kanadische Waldbrand Austreter
	  Kontrollfeld fr fr Lschzug, Klassen-Definition
                             -------------------
    begin                : Sat Sep 30 2000
    copyright            : (C) 2000 by Ulrich Bochert
    email                : schroeder_bochert@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KONTROLL1_H
#define KONTROLL1_H

#include <qwidget.h>
#include <qpushbutton.h>

class QLabel;
class QButton;
class QWidget;
class QCheckBox;

class Kontroll: public QWidget
{
        Q_OBJECT
public:
        Kontroll(QWidget *parent, const char *name, int=1, double=0,
                 double=0, int=0, int=0, bool=false);

        ~Kontroll();
        void closeEvent(class QCloseEvent *);

        static bool getInstanzExists();

        void focusOutEvent(QFocusEvent *);
        void moveEvent(QMoveEvent *);
        void paintEvent(QPaintEvent *);
        void mouseReleaseEvent(QMouseEvent *);
        void mousePressEvent(QMouseEvent *);
        void mouseMoveEvent(QMouseEvent *);
        void BenzinZeigen();
        void WasserZeigen();
        void init(int=1, double=0,double=0, int=0, int=0, bool=false);

protected:
private:
        static bool InstanzExists;
        void RichtungZeigen();
        int FeuerWehr;
        double Richtung;
        double Speed;
        int Wasser;
        int Benzin;
        bool Loeschen;//True: Lschauftrag
        int MausPX;
        int MausRX;
        int MausPY;
        int MausRY;
        QLabel *KRichtungL;
        QPushButton *KRichtungBplus;
        QPushButton *KRichtungBminus;
        QLabel *KSpeedL;
        QPushButton *KSpeedBplus;
        QPushButton *KSpeedBminus;
        QWidget *BenzinBalken;
        QWidget *WasserBalken;
        QCheckBox *LoeschBox;

protected slots:
        void RichtungSlot(double);
        void setRichtungP();
        void setRichtungM();

        void SpeedSlot(double);
        void setSpeedP();
        void setSpeedM();

        void WasserSlot(int);

        void BenzinSlot(int);

        void LoeschenSlot(bool);
        void setLoeschen();
signals:
        void RichtungChanged(double);
        void SpeedChanged(double);
        void LoeschenChanged(bool);
        void LoeschenChanged2(int, bool);
        void k1_hidden(int FeuerWehr);
        void k1_moved();
};

#endif //KONTOLL1_H