#include "SolTopLevelWidget.moc"
#include "SolTopLevelWidget.h"

#include <kapp.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h> 


#define NEWGAME_TB_ID 0
#define DEAL_TB_ID 1
#define UNDO_TB_ID 2

SolTopLevelWidget::SolTopLevelWidget( const char *name = NULL )
  : KTopLevelWidget(name)
{ 
  /* Load config file options */

  QString tempstr;
  KConfig *config = kapp->getConfig();
  config->setGroup("KDE Setup");
  if( !config->hasKey("IconPath") )
     {
       tempstr = KApplication::kdedir();
       tempstr += "/lib/pics:";
       tempstr += KApplication::kdedir();
       tempstr += "/lib/pics/toolbar";
       config->writeEntry("IconPath", tempstr);
       config->sync();
     } 

  config->setGroup("ksol");
  int w = config->readNumEntry("Width",DEF_WIDTH);
  int h = config->readNumEntry("Height",DEF_HEIGHT);
  

  /* Add our status bar, menu, and toolbar */

  statusbar = new KStatusBar(this);
  setStatusBar(statusbar);
  
  toolbar = new KToolBar(this);
  addToolBar(toolbar);
  
  filemenu = new QPopupMenu();
  gamemenu = new QPopupMenu();
  helpmenu = new QPopupMenu();
  
  menubar = new KMenuBar(this);
  setMenu(menubar);
  menubar->insertItem("&File",filemenu);
  menubar->insertItem("&Game",gamemenu);
  menubar->insertItem("&Help",helpmenu);


  /* Start up ksol */

  sol = new SolTable(this);    
  setView(sol);
  //  sol->_newgame();  

  /* Connect all of our slots to ksol */

  connect(sol,SIGNAL(score(int)),this,SLOT(score(int)));
  connect(sol,SIGNAL(newGameStarted(SolTable::GameStyle)),
	  this,SLOT(newGameStarted(SolTable::GameStyle)));
  connect(sol,SIGNAL(undoable(bool)),this,SLOT(undoable(bool)));
  connect(sol,SIGNAL(gameWon(int)),this,SLOT(gameWon()));

  /* Add the entries to our status bar, toolbar, and menus */
  
  statusbar->insertItem("Score    ",0);
  statusbar->insertItem("",1);
  
  KIconLoader kil;
  QPixmap icon = kil.loadIcon("AceKingCards.xpm");
  toolbar->insertButton(icon,NEWGAME_TB_ID,SIGNAL(clicked(int)),this,SLOT(newgame()),1,
		      "Start a new game");
  icon = kil.loadIcon("DollarCorner.xpm");
  toolbar->insertButton(icon,DEAL_TB_ID,SIGNAL(clicked(int)),sol,SLOT(_deal()),1,"Deal a new hand");
  icon = kil.loadIcon("reload.xpm");
  toolbar->insertButton(icon,UNDO_TB_ID,SIGNAL(clicked(int)),sol,SLOT(_undo()),1,"Undo");

  filemenu->insertItem("E&xit",this,SLOT(_exit()));
  
  undo_id = gamemenu->insertItem("&Undo",sol,SLOT(_undo()),CTRL+Key_U);
  deal_id = gamemenu->insertItem("&Deal",sol,SLOT(_deal()),CTRL+Key_D);
  gamemenu->insertItem("&New Game",this,SLOT(newgame()),CTRL+Key_N);
  gamemenu->insertSeparator();
  gamemenu->insertItem("&Options",this,SLOT(options()),CTRL+Key_O);

  helpmenu->insertItem("Help",this,SLOT(help()));
  helpmenu->insertItem("About",this,SLOT(about()));
  
  sol->_newgame();    
  show();
  resize(w,h);
}
  
SolTopLevelWidget::~SolTopLevelWidget()
{
  delete sol;
  delete menubar;
  delete gamemenu;
  delete helpmenu;
  delete filemenu;
  delete toolbar;
  delete statusbar;
}

void SolTopLevelWidget::score(int scr)
{
  QString textscr;
  textscr.setNum(scr);
  statusbar->changeItem(textscr.data(),1);
}

void SolTopLevelWidget::newGameStarted(SolTable::GameStyle gs)
{
  bool temp = 0;
  if (gs == SolTable::Vegas) {
    temp = 1;
    statusbar->changeItem("Score  $ ",0);
  }
  else  statusbar->changeItem("Score    ",0);

  gamemenu->setItemEnabled(deal_id, temp);
  toolbar->setItemEnabled(DEAL_TB_ID, temp);
}

void SolTopLevelWidget::undoable(bool canUndo)
{
    toolbar->setItemEnabled(UNDO_TB_ID,canUndo);
  gamemenu->setItemEnabled(undo_id,canUndo);
}

void SolTopLevelWidget::about()
{
  QMessageBox::message("About","KSol  Version 0.1.0\nCopyright 1997\nSteve Dodd\nsdodd@undergrad.math.uwaterloo.ca","Ok");
}

void SolTopLevelWidget::help()
{
  KApplication::getKApplication()->invokeHTMLHelp("","");
}

void SolTopLevelWidget::options()
{
  SolTableOptions so(sol);
  if (so.exec()) sol->_newgame();
}

void SolTopLevelWidget::newgame() /* This calls the newgame() if the user really wants it. */
{
  bool ok = QMessageBox::query("New Game?",
			       "Are you sure you want to start a new game?");
  if (ok) sol->_newgame();
}

void SolTopLevelWidget::_exit()
{
    KConfig *config = kapp->getConfig();
    config->setGroup("ksol");
    config->writeEntry("Width",width());
    config->writeEntry("Height",height());
    config->sync();

    kapp->quit();
}

void SolTopLevelWidget::gameWon()
{
  QMessageBox::message("You Won!","You won the game!","Whatever");
}
