#define _Cards_

#ifndef _BaseCard_
#include "BaseCard.h"
#endif

#include <QwSpriteField.h>

class Card : public BaseCard {
public:

  Card(QwSpritePixmapSequence& s, int ct, int cn, int cs, int upframe, int downframe);
  ~Card();

  bool setCardType(int ct); 
  int cardSuit();
  int cardNum();
  
  void setFacedownFrame(int frame_num);
  void setFace(bool face);
  bool faceUp();
  
  BaseCard* nextCard();
  BaseCard* prevCard();
  bool setNextCard(BaseCard* card);
  bool setPrevCard(BaseCard* card);
  void cleanCard();
  
  bool isTopCard();
  bool isCardAbove(BaseCard *card);
  bool isCardBelow(BaseCard *card);
  BaseCard* topCard();

  bool pickupCards();
  void putdownCards();
  void moveCardsTo(int nx, int ny);
  bool dragCardsTo(int nx, int ny, int nz, int dx=0, int dy=0, bool force=0);
  void putbackCards();

  bool dropCards(BaseCard *onCard, int dx, int dy);
  
private:
  BaseCard *next, *prev;
  bool picked_up, faceup;
  int px,py,pz,cnum, csuit, faceupFrame;
  int facedownFrame;
};




