/***************************************************************************
                          krossword.h  -  description
                             -------------------
    begin                : Fri Jan  7 11:43:16 CET 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KROSSWORD_H
#define KROSSWORD_H

#include <kapp.h>
#include <qwidget.h>
#include <ktmainwindow.h>
#include "puzzlewidget.h"
#include "newpuzzlewidget.h"
#include "questionswidget.h"
#include "editorwidget.h"

/**
  *@author Arjan Buursink
  */

class Krossword : public KTMainWindow  {
	Q_OBJECT
public:
	Krossword();
	~Krossword();
private:
	KMenuBar * menu;
	KToolBar * toolbar;
	QPixmap new_pixmap, open_pixmap, save_pixmap, exit_pixmap;
	PuzzleWidget * pw;
	NewPuzzleWidget * npw;
	QPopupMenu * filemenu;
	QPopupMenu * optionsmenu;
	QPopupMenu * solutionmenu;
	QPopupMenu * helpmenu;
	int savepuz_id;
	QLineEdit * title;
	QLineEdit * author;
	QLineEdit * copyright;
	QFrame * puzzleframe;
	QuestionsWidget * questions_widget;
	EditorWidget * editor_widget;
	int playmode_id,editmode_id,show_word_corr_id,show_letter_corr_id,dont_show_corr_id;
	void editorToQuestions();
	void closeDatabase();
	void resizeWidget();
	void save(QString);
	void loadPuzzle();
	bool puzzle_open;
public slots:
	void openPuzzle();
	void newPuzzle();
	void npwOkClicked();
	void npwCancelClicked();
	void savePuzzleAs();
	void savePuzzle();
	void solutionMenuEnable(int,bool);
	void questionsWidgetSelect(int,bool,bool);
	void showWordCorr();
	void showLetterCorr();
	void dontShowCorr();
	void exit();
	void showHelpContents();
};

#endif
