#ifndef KINVWND_H
#define KINVWND_H
#include <ktablistbox.h>
#include <qpopupmenu.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qdialog.h>
#include "rogue/rogue.h"

object *objfirst(int mask, int inusemask=0);
object *objnext(object *obj, int mask, int inusemask=0);
char *objstr(object *obj, char *str);

class KInvWnd:public QDialog
{
  Q_OBJECT
public:
  KInvWnd(QWidget *parent=NULL, char *name=NULL, int amask=ALL_OBJECTS,
    bool select=false, object *rpack=NULL);
  void show(void);
  static const char *useName(object *obj);
  static void doUse(int c);
  static int getObjIconId(object *obj);
public slots:
  virtual void selectbt(void);
  virtual void setusename(int, int);
  virtual void usebt();
  virtual void showPopup(int, int);
protected:
  QPushButton *close, *use;
  KTabListBox *tlb;
  object *pack;
  int mask;
  friend class KItemMenu;
};

class KItemMenu:public QPopupMenu
{
  Q_OBJECT
public:
  KItemMenu(int _item, KInvWnd *, int _tlbitem);
public slots:
  void fillPopup();
  void use();
  void call();
  void drop();
protected:
  int item, tlbitem;
  KInvWnd *wnd;
};

class KInvPopup:public QPopupMenu
{
  Q_OBJECT
public:
  KInvPopup(int _mask, int _inusemask=0);
public slots:
  void fillPopup();
protected:
  int mask, inusemask;
};

class KNItemDlg:public QDialog
{
  Q_OBJECT
public:
  KNItemDlg(QWidget *);
public slots:
  void listclick(int i);
protected slots:
  void accept(void);
protected:
  QListBox *list1, *list2;
};

class KStrDlg:public QDialog
{
  Q_OBJECT
public:
  KStrDlg(const char *q, bool pass=false, QWidget *parent=NULL, char *name=NULL);
  virtual ~KStrDlg(void) {}
  virtual const char *text() {return le->text();}
protected:
  QLineEdit *le;
};

class KSellItemDlg:public QDialog
{
  Q_OBJECT
public: 
  KSellItemDlg(QWidget *parent=NULL, char *name=NULL);
  void show();
  virtual ~KSellItemDlg(void) {}
  virtual void add(char *text, int price);
protected:
  KTabListBox *tl;
  long egold;
};
#endif