/***************************************************************************
                          kcard.cpp  -  description
                             -------------------
    begin                : Mon Apr 24 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#include "kcard.h"
#include "cards.h"
#include <qpainter.h>
#include <qrect.h>
#include <qmessagebox.h>
#include <qimage.h>



KCard::KCard(QWidget *parent, const char *name) : QWidget(parent, name)
{
	parentWidget = parent;
	setFixedSize(76,98);

	border=1;
	allowMark=true;
	allowHighlight=true;
	marked=false;
	color=QColor("black");
	bgColor = parent->backgroundColor();
	mColor=QColor("yellow");
	lbDown = false;

	setCardNumber(-1);

 	initValues();
	installEventFilter(this);

	blinkTimer = new QTimer(this);
	connect( blinkTimer, SIGNAL(timeout()), SLOT(blinkTimerEvent()) );
}

KCard::~KCard()
{
	removeEventFilter(this);
	delete blinkTimer;
}

void KCard::paintEvent(QPaintEvent *)
{
	if (!isVisible())
		return;
	bgColor = parentWidget->backgroundColor();

	QPainter painter(this);
	QRect *br = new QRect(0,0,76,98);
	painter.setPen(QPen(bgColor,4,SolidLine));
	painter.drawRect(rect());
	delete br;
	QRect  *r = new QRect(1,1,74,96);
	
	painter.setPen(QPen(color,border,SolidLine));
	painter.drawRoundRect(*r,4,4);
	delete r;
}

bool KCard::eventFilter(QObject* object, QEvent* event)
{	
	if (event->type() == Event_Enter)
	{
		highlightField(true);
		return true;
	}
	else
	if (event->type() == Event_Leave)
	{
		highlightField(false);
		return true;		
	}
	else
	if (event->type() == Event_MouseButtonPress)
	{
		QMouseEvent* e = (QMouseEvent*) event;
		mousePresseEvent(e);		
		return true;
	}
	else
	if (event->type() == Event_MouseButtonRelease)
	{
		QMouseEvent* e = (QMouseEvent*) event;
		mouseReleaseEvent(e);
		return true;
	}
	else
	{
		return false;
	}
}

void KCard::mousePresseEvent(QMouseEvent *e)
{
  if (e->button() != LeftButton)
		return;
  bool hit = inCard(e->pos());
  if (hit) // mouse press on card
	{
		lbDown = true;	// remember: mouse press on card
		emit pressed(this);
	}
}

void KCard::mouseReleaseEvent(QMouseEvent *e)
{
  if (e->button() != LeftButton)
		return;

  if (inCard(e->pos()))
	{		// mouse release on card
		emit released(this);
		if (lbDown)
			emit clicked(this);
  }
  lbDown = false;				// mouse up
}

bool KCard::inCard( const QPoint &pos ) const
{
    return rect().contains(pos);
}

void KCard::initValues()
{
	int val = -1;
	cardValues[-1]=val;
	cardValues[0]=val;
	val=2;
	for (int i=1;i<53;i++)
	{
		cardValues[i]=val;
		if (i%4==0)
			val++;
		if (i==36)
			val=2;
		if (i==48)
			val=1;
	}	
}

int KCard::getValue()
{
	return cardValues[cardNumber];
}

bool KCard::setMColor(const QColor& color)
{
	mColor = color;
	return true;
}

const QColor& KCard::getMColor()
{
	return mColor;
}

bool KCard::isMarked()
{
	return marked;
}

bool KCard::enableMarking(bool state)
{
	if (marked)
		allowMark = true;
	else
	  allowMark = state;
	return allowMark;	
}

bool KCard::enableHighlightning(bool state)
{
	allowHighlight=state;
	if (!state)
		border=1;
	return allowHighlight;
}

bool KCard::markField(bool state)
{
	if (!allowMark)
		return false;
	marked = state;		
	border=2;
	if (marked)
		color = mColor;
	else
		color = QColor(black);
	update();
	return marked;
}

void KCard::highlightField(bool state)
{
	if (!allowHighlight)
		return;
	if (state==true)
		border=3;
	else
	{
		if (!marked)
			border=1;
		else
			border=2;
	}
	update();
}

bool KCard::setCardNumber(int number)
{
	QPixmap *pm;

	switch (number)
	{
		case empty:
			setBackgroundColor(QColor(white));
			break;
  	case back:
			pm = new QPixmap(pback);
			break;		

  	case club2:
			pm = new QPixmap(pclub2);
			break;		
		case club3:
			pm = new QPixmap(pclub3);
			break;		
		case club4:
			pm = new QPixmap(pclub4);
			break;		
 		case club5:
			pm = new QPixmap(pclub5);
			break;		
		case club6:
			pm = new QPixmap(pclub6);
			break;		
		case club7:
			pm = new QPixmap(pclub7);
			break;		
		case club8:
			pm = new QPixmap(pclub8);
			break;		
		case club9:
			pm = new QPixmap(pclub9);
			break;		
		case club10:
			pm = new QPixmap(pclub10);
			break;		
		case clubJack:
			pm = new QPixmap(pclubjack);
			break;		
		case clubQueen:
			pm = new QPixmap(pclubqueen);
			break;		
		case clubKing:
			pm = new QPixmap(pclubking);
			break;		
		case clubAce:
			pm = new QPixmap(pclubace);
			break;		
  	case diamond2:
			pm = new QPixmap(pdiamond2);
			break;		
		case diamond3:
			pm = new QPixmap(pdiamond3);
			break;		
		case diamond4:
			pm = new QPixmap(pdiamond4);
			break;		
 		case diamond5:
			pm = new QPixmap(pdiamond5);
			break;		
		case diamond6:
			pm = new QPixmap(pdiamond6);
			break;		
		case diamond7:
			pm = new QPixmap(pdiamond7);
			break;		
		case diamond8:
			pm = new QPixmap(pdiamond8);
			break;		
		case diamond9:
			pm = new QPixmap(pdiamond9);
			break;		
		case diamond10:
			pm = new QPixmap(pdiamond10);
			break;		
		case diamondJack:
			pm = new QPixmap(pdiamondjack);
			break;		
		case diamondQueen:
			pm = new QPixmap(pdiamondqueen);
			break;		
		case diamondKing:
			pm = new QPixmap(pdiamondking);
			break;		
		case diamondAce:
			pm = new QPixmap(pdiamondace);
			break;		
  	case hearts2:
			pm = new QPixmap(phearts2);
			break;		
		case hearts3:
			pm = new QPixmap(phearts3);
			break;		
		case hearts4:
			pm = new QPixmap(phearts4);
			break;		
 		case hearts5:
			pm = new QPixmap(phearts5);
			break;		
		case hearts6:
			pm = new QPixmap(phearts6);
			break;		
		case hearts7:
			pm = new QPixmap(phearts7);
			break;		
		case hearts8:
			pm = new QPixmap(phearts8);
			break;		
		case hearts9:
			pm = new QPixmap(phearts9);
			break;		
		case hearts10:
			pm = new QPixmap(phearts10);
			break;		
		case heartsJack:
			pm = new QPixmap(pheartsjack);
			break;		
		case heartsQueen:
			pm = new QPixmap(pheartsqueen);
			break;		
		case heartsKing:
			pm = new QPixmap(pheartsking);
			break;		
		case heartsAce:
			pm = new QPixmap(pheartsace);
			break;		
  	case spades2:
			pm = new QPixmap(pspades2);
			break;		
		case spades3:
			pm = new QPixmap(pspades3);
			break;		
		case spades4:
			pm = new QPixmap(pspades4);
			break;		
 		case spades5:
			pm = new QPixmap(pspades5);
			break;		
		case spades6:
			pm = new QPixmap(pspades6);
			break;		
		case spades7:
			pm = new QPixmap(pspades7);
			break;		
		case spades8:
			pm = new QPixmap(pspades8);
			break;		
		case spades9:
			pm = new QPixmap(pspades9);
			break;		
		case spades10:
			pm = new QPixmap(pspades10);
			break;		
		case spadesJack:
			pm = new QPixmap(pspadesjack);
			break;		
		case spadesQueen:
			pm = new QPixmap(pspadesqueen);
			break;		
		case spadesKing:
			pm = new QPixmap(pspadesking);
			break;		
		case spadesAce:
			pm = new QPixmap(pspadesace);
			break;		

		default:
			return false;
	}
	if (number != empty)	
	{
		setBackgroundPixmap(*pm);
		delete pm;
	}
	cardNumber = number;
	update();
	return true;
}

int KCard::getCardNumber()
{
	return cardNumber;
}

void KCard::setPos(int left, int top)
{
	setGeometry(left,top,76,98);
}

void KCard::startBlink(int count)
{
  count*=2;
	blinkTimer->start(500);
  if (count>0)
		blinkNumbers = count;
	else
		blinkNumbers = 1;
	blinkCount = 0;
	marked=false;
}

void KCard::stopBlink()
{
  if (blinkTimer->isActive())
		blinkTimer->stop();
	border=1;
	if (isMarked())
		markField(false);		
}

void KCard::blinkTimerEvent()
{
	if (blinkCount>=blinkNumbers)
	{
		stopBlink();
		return;
	}
	border=2;
	if (isMarked())
		markField(false);
	else
		markField(true);
	blinkCount++;
}