#ifndef FRUIT_H
#define FRUIT_H

#include "board.h"

enum fruitState { inactive, active, eaten };

class Fruit {
public:
    Fruit(Board *b);
    void setEaten(int duration);
    void setLevel(int level, int wDuration, int fDuration);
    void setPosition(int pos);
    fruitState state();
    int position();
    bool move();
    int pix();

private:
    Board   *board;

    fruitState actualState;		// the state of fruit

    int  timeLeft;			// Ticks remaining of current state

    int  waitDuration;			// Time before fruit appears
    int  fruitDuration;			// Length of active-time in ticks

    int  actualPosition;		// actual position on board
    int  lastPosition;			// the last position of the fruit
    int  actualLevel;			// level for kind of fruit and score
};

#endif // FRUIT_H

