//  knine.cpp 
//  contains member functions of knine
//
#include <iostream.h>
#include <kapp.h>
#include "knine.h"
#include <qpainter.h>
#include <kmsgbox.h>
#include "knine.moc"
#include <stdlib.h>

int menuheight=30;
int window_width = 500;
int window_height = 425;
QString picsdir = "./";
QBrush brush_red (red);
QBrush brush_yellow (yellow);
QBrush brush_blue (blue);
QBrush brush_black (black);

knine::knine(QWidget * parent, const char * name) : QWidget(parent,name)
{
    this -> resize (400,370); //default size

    filemenu = new QPopupMenu ();
    filemenu -> insertItem("New game",this,SLOT(newGame() ));
    filemenu -> insertSeparator();
    filemenu -> insertItem("Exit",this,SLOT(fileQuit() ));

    optionsmenu = new QPopupMenu ();
    gbp_id = optionsmenu -> insertItem("Gameboard pixmap",this,SLOT(gameBoardPixmap() ));
    gbc_id = optionsmenu -> insertItem("GameBoard color",this,SLOT(gameBoardColor() ));
    optionsmenu -> setItemChecked(gbc_id, TRUE);
    optionsmenu -> insertSeparator();
    p1c_id = optionsmenu -> insertItem("Player1 is Computer",this,SLOT(player1Comp() ));
    p2c_id = optionsmenu -> insertItem("Player2 is Computer",this,SLOT(player2Comp() ));
    p1c=0;
    p2c=1;
    optionsmenu -> setItemChecked(p1c_id, FALSE);
    optionsmenu -> setItemChecked(p2c_id, TRUE);
    optionsmenu -> setCheckable(TRUE);
    optionsmenu -> insertSeparator();
    ds_id = optionsmenu -> insertItem("Default size",this,SLOT(defaultSize() ));
    ss_id = optionsmenu -> insertItem("Small size",this,SLOT(smallSize() ));
    ls_id = optionsmenu -> insertItem("Large size",this,SLOT(largeSize() ));
    optionsmenu -> setItemChecked(ds_id,TRUE);
    

    levelmenu = new QPopupMenu ();
    l1_id = levelmenu -> insertItem("Level 1", this,SLOT(level1() ));
    l2_id = levelmenu -> insertItem("Level 2", this,SLOT(level2() ));
    l3_id = levelmenu -> insertItem("Level 3", this,SLOT(level3() ));
    levelmenu -> setItemChecked(l1_id,TRUE);
    
    menu = new KMenuBar(this);
    menu -> insertItem("File",filemenu);
    menu -> insertItem("Options",optionsmenu);
    menu -> insertItem("Level",levelmenu);

    initBoard();
}

knine::~knine()
{
}

void knine::player1Comp()
{
   if(p1c == 0)
    optionsmenu -> setItemChecked(p1c_id,TRUE);
    else
    optionsmenu -> setItemChecked(p1c_id,FALSE);
   p1c=1-p1c;
}

void knine::player2Comp()
{
   if(p2c == 0)
    optionsmenu -> setItemChecked(p2c_id,TRUE);
    else
    optionsmenu -> setItemChecked(p2c_id,FALSE);
   p2c=1-p2c;
}

void knine::defaultSize()
{
    this->resize(400,int(400/1.08));
    optionsmenu -> setItemChecked(ds_id,TRUE);
    optionsmenu -> setItemChecked(ss_id,FALSE);
    optionsmenu -> setItemChecked(ls_id,FALSE);
}

void knine::smallSize()
{
    this->resize(300,int(300/1.08));
    optionsmenu -> setItemChecked(ds_id,FALSE);
    optionsmenu -> setItemChecked(ss_id,TRUE);
    optionsmenu -> setItemChecked(ls_id,FALSE);
}

void knine::largeSize()
{
    this->resize(500,int(500/1.08));
    optionsmenu -> setItemChecked(ds_id,FALSE);
    optionsmenu -> setItemChecked(ss_id,FALSE);
    optionsmenu -> setItemChecked(ls_id,TRUE);
}
    
void knine::gameBoardPixmap()
{
 QPixmap pixmap_red(picsdir + "stone1.xpm");
 QPixmap pixmap_yellow(picsdir + "stone2.xpm");
 QPixmap pixmap_blue(picsdir + "board.xpm");
 QPixmap pixmap_black(picsdir + "gitter.xpm");
 optionsmenu ->setItemChecked(gbp_id,TRUE);
 optionsmenu ->setItemChecked(gbc_id,FALSE);
 brush_red.setPixmap(pixmap_red);
 brush_yellow.setPixmap(pixmap_yellow);
 brush_blue.setPixmap(pixmap_blue);
 brush_black.setPixmap(pixmap_black);
 repaint();
}

void knine::gameBoardColor()
{
    optionsmenu -> setItemChecked(gbp_id,FALSE);
    optionsmenu -> setItemChecked(gbc_id,TRUE);
    brush_red.setStyle(SolidPattern);
    brush_blue.setStyle(SolidPattern);
    brush_yellow.setStyle(SolidPattern);
    repaint();
}

void knine::level1()
{
    levelmenu -> setItemChecked(l1_id,TRUE);
    levelmenu -> setItemChecked(l2_id,FALSE);
    levelmenu -> setItemChecked(l3_id,FALSE);
}
void knine::level2()
{
    levelmenu -> setItemChecked(l1_id,FALSE);
    levelmenu -> setItemChecked(l2_id,TRUE);
    levelmenu -> setItemChecked(l3_id,FALSE);
}
void knine::level3()
{
    levelmenu -> setItemChecked(l1_id,FALSE);
    levelmenu -> setItemChecked(l2_id,FALSE);
    levelmenu -> setItemChecked(l3_id,TRUE);
}

int knine::isallowed(gamestate h,int feld)
{
 int i,j,k,owno=0;
 int xp,yp,zp;
 
 int myboard[3][3][3];
 for(i=0;i<3;i++)
  for(j=0;j<3;j++)
   for(k=0;k<3;k++)
    myboard[i][j][k]=0;

 for(i=0;i<3;i++)
 {
  for(j=0;j<3;j++)
  {
   for(k=0;k<3;k++)
   {
    xp=i;
    yp=j;
    zp=k;
    if(h.board[0][yp][xp] == 3-h.activeplayer && h.board[1][yp][xp] == 3-h.activeplayer && h.board[2][yp][xp] == 3-h.activeplayer && ((xp+yp)%2)==1 ) {myboard[0][yp][xp]=1;myboard[1][yp][xp]=1;myboard[2][yp][xp]=1;}
    if(h.board[zp][0][xp] == 3-h.activeplayer && h.board[zp][1][xp] == 3-h.activeplayer && h.board[zp][2][xp] == 3-h.activeplayer) {myboard[zp][0][xp]=1;myboard[zp][1][xp]=1;myboard[zp][2][xp]=1;}
    if(h.board[zp][yp][0] == 3-h.activeplayer && h.board[zp][yp][1] == 3-h.activeplayer && h.board[zp][yp][2] == 3-h.activeplayer) {myboard[zp][yp][0]=1;myboard[zp][yp][1]=1;myboard[zp][yp][2]=1;}
   }
  }
 } 
 for(i=0;i<3;i++)
  for(j=0;j<3;j++)
   for(k=0;k<3;k++)
    if(h.board[i][j][k] == 3-h.activeplayer && myboard[i][j][k] == 0) owno=1;
 if(owno == 1 && h.board[feld/9][(feld/3)%3][feld%3] == 3-h.activeplayer && myboard[feld/9][(feld/3)%3][feld%3] == 0) return 1;
 if(owno == 0 && h.board[feld/9][(feld/3)%3][feld%3] == 3-h.activeplayer ) return 1;
 return 0;
}

int knine::checkmuehle(gamestate h,int feld)
{
 int xp,yp,zp;
 xp=feld%3;
 yp=(feld/3)%3;
 zp=feld/9;
 if(h.board[0][yp][xp] == h.activeplayer && h.board[1][yp][xp] == h.activeplayer && h.board[2][yp][xp] == h.activeplayer && ((xp+yp)%2)==1 ) return 1;
 if(h.board[zp][0][xp] == h.activeplayer && h.board[zp][1][xp] == h.activeplayer && h.board[zp][2][xp] == h.activeplayer) return 1;
 if(h.board[zp][yp][0] == h.activeplayer && h.board[zp][yp][1] == h.activeplayer && h.board[zp][yp][2] == h.activeplayer) return 1;
 return 0;
}

int knine::remove_stone(gamestate &h,int feld,int silent)
{
 char buf[50];
 if(h.board[feld/9][(feld/3)%3][feld%3]==3-h.activeplayer && isallowed(h,feld) && h.muehlestatus == 1 && (feld%9) != 4)
 {
  h.board[feld/9][(feld/3)%3][feld%3]=0;
  h.spielsteine[2-h.activeplayer]--;
  h.muehlestatus=0;
  if(g.spielsteine[2-g.activeplayer] < 3 && g.steine[2-g.activeplayer] == 0)
  {
   repaint();
   sprintf(buf,"%s wins!",playername[g.activeplayer-1]);
   KMsgBox::message(0,"",buf);
   gameactive=0;
  }
  h.activeplayer=3-h.activeplayer;
  if(!silent) repaint();
  return 1;
 } 
 return 0;
}

int knine::set_stone(gamestate &h,int feld,int silent)
{
 char buf[50];
 if(h.steine > 0 && h.board[feld/9][(feld/3)%3][feld%3]==0 && (feld%9) != 4)
 {
  h.board[feld/9][(feld/3)%3][feld%3]=h.activeplayer;
  h.steine[h.activeplayer-1]--;
  h.spielsteine[h.activeplayer-1]++;
  if(checkmuehle(h,feld))
  {
   if(!silent)
   {
    repaint();
    sprintf(buf,"%s: Take Stone\n from %s",playername[h.activeplayer-1],playername[2-h.activeplayer]);
    KMsgBox::message(0,"knine",buf);
   }
   h.muehlestatus=1;
   h.activeplayer=3-h.activeplayer;
  }
  h.activeplayer=3-h.activeplayer;
  if(!silent) repaint();
  return 1;
 }
 return 0;
}

int knine::move_stone(gamestate &h,int oldfeld,int newfeld,int silent)
{
 char buf[50];
 int dist;
 dist=abs(oldfeld/9-newfeld/9)+abs( ((oldfeld/3)%3) - ((newfeld/3)%3) ) +abs((newfeld%3)-(oldfeld%3));
 if(h.board[oldfeld/9][(oldfeld/3)%3][oldfeld%3] != h.activeplayer) return 0;
 if (dist != 1 && h.spielsteine[h.activeplayer-1] > 3 ) return 0;
 if ( (newfeld %9) == 4) return 0;
 if(h.board[newfeld/9][(newfeld/3)%3][newfeld%3] != 0) return 0;
 if(((newfeld%9)%2) == 0 && oldfeld/9 != newfeld/9) return 0;
 h.board[oldfeld/9][(oldfeld/3)%3][oldfeld%3]=0;
 h.board[newfeld/9][(newfeld/3)%3][newfeld%3]=h.activeplayer;
 if(checkmuehle(h,newfeld))
 {
  if(!silent)
  {
   repaint();
   sprintf(buf,"%s: Take Stone\n from %s",playername[h.activeplayer-1],playername[2-h.activeplayer]);
   KMsgBox::message(0,"knine",buf);
  }
  h.muehlestatus=1;
  h.activeplayer=3-h.activeplayer;
 }
 h.activeplayer=3-h.activeplayer;
 if(!silent) repaint();
 return 1;
}
 

void knine::next_player(gamestate h)
{
 if(gameactive)
 {
  if(h.activeplayer == 1 && p1c == 1 || h.activeplayer == 2 && p2c == 1) play_comp();
  if(h.activeplayer == 1 && p1c == 1 || h.activeplayer == 2 && p2c == 1 && g.muehlestatus == 1 ) play_comp();
 }
} 

int knine::getscore(gamestate h)
{
 int score;
 score=0;
 if(h.muehlestatus) score+=1000;
 return score;
}

void knine::play_comp(void)
{
 int feld,newfeld;
 int maxnum,maxnum1,maxnum2,maxscore,score;
 int i,j;
 gamestate h;
 if(g.muehlestatus == 1)
 {
  maxnum=-1;
  maxscore=0;
  for(i=0;i<27;i++)
  {
   h=g;
   if(remove_stone(h,i,1) == 1)
   {
    score=getscore(h);
    if(score > maxscore)
    {
     maxnum=i;
     maxscore=score;
    }
   }
  }
  if(maxnum != -1)
  {
   remove_stone(g,maxnum,0);
  }
  else
  {
   do feld=rand()%27;
   while(remove_stone(g,feld,0) == 0);
  } 
 }
 else
 if(g.steine[g.activeplayer-1] > 0)
 {
  maxnum=-1;
  maxscore=0;
  for(i=0;i<27;i++)
  {
   h=g;
   if(set_stone(h,i,1) == 1)
   {
    score=getscore(h);
    if(score >maxscore) { maxnum=i; maxscore=score; }
   }
  }
  if(maxnum != -1)
  {
   set_stone(g,maxnum,0);
  }   
  else
  {
   do feld=rand()%27;
   while(set_stone(g,feld,0) == 0);
  }
 }
 else
 {
  maxnum1=-1;
  maxnum2=-1;
  maxscore=0;
  for(i=0;i<27;i++)
  {
   for(j=0;j<27;j++)
   {
    h=g;
    if(move_stone(h,i,j,1) == 1)
    {
     score=getscore(h);
     if(score > maxscore)
     {
      maxnum1=i;
      maxnum2=j;
      maxscore=score;
     } 
    }
   }
  } 
  if(maxnum1 != -1)
  {
   move_stone(g,maxnum1,maxnum2,0);
  }
  else
  {
   do
   { 
    feld=rand()%27;
    newfeld=rand()%27;
   }
   while(move_stone(g,feld,newfeld,0) == 0);
  }
 }
 return;
}

void knine::mousePressEvent(QMouseEvent * m)
{
 QPainter p;
 int feldtable[49]={	18,-1,-1,19,-1,-1,20,
			-1, 9,-1,10,-1,11,-1,
			-1,-1, 0, 1, 2,-1,-1,
			21,12, 3,-1, 5,14,23,
			-1,-1, 6, 7, 8,-1,-1,
			-1,15,-1,16,-1,17,-1,
			24,-1,-1,25,-1,-1,26};

 int xpos,ypos,feld;
 xpos=(m->x()+distx/2)/distx;
 ypos=(m->y()+disty/2-menuheight)/disty;
 if(xpos <1) xpos=1;
 if(xpos >7) xpos=7;
 if(ypos <1) ypos=1;
 if(ypos >7) ypos=7;
 feld=feldtable[(ypos-1)*7+xpos-1];
 if(feld != -1 && gameactive == 1 && (p1c == 0 && g.activeplayer == 1 || p2c == 0 && g.activeplayer==2))
 {
  if(g.muehlestatus == 1)
  {
   remove_stone(g,feld,0);
  }
  else
  if(g.steine[g.activeplayer-1] >0)
  {
   set_stone(g,feld,0);
  }
  else
  {
   if(markposx ==xpos  && markposy == ypos )
   {
    markposx=-1;
    markposy=-1;
    activefeld=-1; 
    repaint();
   }
   else
   if(g.board[feld/9][(feld/3)%3][feld%3] == g.activeplayer)
   {
    markposx=xpos;
    markposy=ypos;
    activefeld=feld;
    repaint();
   }
   else
   if(g.board[feld/9][(feld/3)%3][feld%3] == 0 && activefeld != -1)
   {
    if(move_stone(g,activefeld,feld,0)== 1)
    {
     markposx=-1;
     markposy=-1;
     activefeld=-1;
     repaint();
    }
   }
  }
  next_player(g);
 }
}

void knine::resizeEvent(QResizeEvent * r)
{
 QSize s=r->size();
 window_width=s.width();
 window_height=s.height()-menuheight;
 distx=(int)((double)window_width/8.0);
 disty=(int)((double)window_height/8.0);
 linewx=(int)window_width/100;
 linewy=(int)window_height/100;
 if(linewx<1) linewx=1;
 if(linewy<1) linewy=1;
}


void knine::fileQuit()
{
 KApplication::exit(0);
}

void knine::takeBack()
{
}

void knine::paintEvent(QPaintEvent*)
{
 int i,j,k;
 QPainter p;
 p.begin(this);
 p.fillRect(0,menuheight,window_width,window_height,brush_blue);
 for(i=1;i<4;i++)
 {
  p.fillRect(i*distx-linewx,i*disty-linewy+menuheight,(4-i)*2*distx+2*linewx,2*linewy,brush_black);
  p.fillRect(i*distx-linewx,i*disty-linewy+menuheight,2*linewx,(4-i)*2*disty+2*linewy,brush_black);
  p.fillRect(i*distx-linewx,(8-i)*disty-linewy+menuheight,(4-i)*2*distx+2*linewx,2*linewy,brush_black);
  p.fillRect((8-i)*distx-linewx,i*disty-linewy+menuheight,2*linewx,(4-i)*2*disty+2*linewy,brush_black);
 }
 p.fillRect(4*distx-linewx,disty-linewy+menuheight,2*linewx,2*disty+2*linewy,brush_black);
 p.fillRect(4*distx-linewx,5*disty-linewy+menuheight,2*linewx,2*disty+2*linewy,brush_black);
 p.fillRect(distx-linewx,4*disty-linewy+menuheight,2*distx+2*linewx,2*linewy,brush_black);
 p.fillRect(5*distx-linewx,4*disty-linewy+menuheight,2*distx+2*linewx,2*linewy,brush_black);
 if(markposx != -1 && markposy != -1)
 {
  p.setPen(white);
  p.drawRect(markposx*distx-distx*0.42,markposy*disty-disty*0.42+menuheight,distx*0.84,disty*0.84);
  p.setPen(black);
 }
 for(i=0;i<3;i++)
 {
  for(j=0;j<3;j++)
  {
   for(k=0;k<3;k++)
   {
    switch(g.board[k][j][i])
    {
     case 1: p.setBrush(brush_red);
             p.drawChord((4+(k+1)*(i-1))*distx-distx*0.4,(4+(k+1)*(j-1))*disty+menuheight-disty*0.4,distx*0.8,disty*0.8,0,5760);
	     break;
     case 2: p.setBrush(brush_yellow);
             p.drawChord((4+(k+1)*(i-1))*distx-distx*0.4,(4+(k+1)*(j-1))*disty+menuheight-disty*0.4,distx*0.8,disty*0.8,0,5760);
	     break;		
    }
   }
  }
 }
 p.fillRect(0,menuheight,window_width,disty/2,g.activeplayer==1?brush_red:brush_yellow);
 p.end();
 
}

void knine::rowClicked(int i)
{
}


void knine::newGame()
{
 initBoard();
 repaint();
}

void knine::initBoard()
{
 int i,j,k;
 for(i=0;i<3;i++)
  for(j=0;j<3;j++)
   for(k=0;k<3;k++)
    g.board[i][j][k]=0;
 g.activeplayer=1;
 g.steine[0]=9;
 g.steine[1]=9;
 g.spielsteine[0]=0;
 g.spielsteine[1]=0;
 markposx=-1;
 markposy=-1;
 activefeld=-1;
 g.muehlestatus=0;
 strcpy(playername[0],"Red Player");
 strcpy(playername[1],"Yellow Player");
 gameactive=1;
 if(p1c == 1) 
 {
  play_comp();
  next_player(g);
 }
}

