/***************************************************************************
                          dlgconnectionwizard.cpp
                             -------------------
    description		 : Connection Wizard Dialog
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlgconnectionwizard.h"


DlgConnectionWizard::DlgConnectionWizard( KmudDoc* document, QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Connection Wizard"));

	doc=document;
	kmudPing = NULL;

	initDialog();

	charDB_ListView->addColumn( i18n("Character") );
	charDB_ListView->addColumn( i18n("Mud") );
	charDB_ListView->setAllColumnsShowFocus( true );
	charDB_ListView->setColumnWidthMode( 0, QListView::Manual );
	charDB_ListView->setColumnWidthMode( 1, QListView::Manual );
	charDB_ListView->setColumnWidth( 0, charDB_ListView->width() / 2 );
	charDB_ListView->setColumnWidth( 1, charDB_ListView->width() / 2 );

	connect( connect_Button, SIGNAL(clicked()), SLOT(slotConnectPressed()) );
	connect( apply_Button, SIGNAL(clicked()), SLOT(slotApplyPressed()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(slotCancelPressed()) );
	connect( new_Button, SIGNAL(clicked()), SLOT(slotNewPressed()) );
	connect( edit_Button, SIGNAL(clicked()), SLOT(slotEditPressed()) );
	connect( delete_Button, SIGNAL(clicked()), SLOT(slotDeletePressed()) );
	connect( ping_Button, SIGNAL(clicked()), SLOT(slotPingButtonClicked()) );

	connect( charDB_ListView, SIGNAL(doubleClicked(QListViewItem*)), SLOT(slotConnectPressed()) );
	connect( charDB_ListView, SIGNAL(selectionChanged(QListViewItem*)), SLOT(slotShowItem(QListViewItem*)) );

	updateListView();
	if (charDB_ListView->firstChild()!=NULL)
		charDB_ListView->setSelected(charDB_ListView->firstChild(),true);

	setDialogState();

}

DlgConnectionWizard::~DlgConnectionWizard(){
}

void DlgConnectionWizard::slotConnectPressed()
{
	doc->writeCharDB();
	done(1);
}

void DlgConnectionWizard::slotApplyPressed()
{
	doc->writeCharDB();
  done(2);
}

void DlgConnectionWizard::slotCancelPressed()
{
	doc->readCharDB();
	reject();
}

void DlgConnectionWizard::slotNewPressed()
{
	DlgConnectionWizardInput d(doc,this,"ConnectionWizardInputDialog");
	QString s;
	CCharacterProfile* prof;
	CMudProfile* mud;


	if (d.exec())
	{

		s=d.getProfile();
		s=(s.simplifyWhiteSpace()).lower();
		s.replace(QRegExp(" "),"");
		s=s+QString(".prof");
		prof = doc->getCharacterProfile(s); // profile already exists?
		if (prof==NULL) 
			prof=new CCharacterProfile; // if not create new
		prof->setFileName(s);

		s=d.getMudTitle();
		s=(s.simplifyWhiteSpace()).lower();
		s.replace(QRegExp(" "),"");
		s=s+QString(".mud");
		mud = doc->getMudProfile(s); // profile already exists?
		if (mud==NULL)
			mud=new CMudProfile; // if not create new
		mud->setFileName(s);

		mud->setTitle(d.getMudTitle());
		mud->setHostName(d.getMudHost());
		s=d.getMudPort();
		mud->setPort(s.toUInt());
		mud->setNamePrompt(d.getNamePrompt());
		mud->setPasswordPrompt(d.getPasswordPrompt());
		
		doc->insertEntry(d.getLogin()+"@"+d.getMudTitle(),d.getLogin(),d.getPassword(),prof,mud);
		
		updateListView();
		if (charDB_ListView->firstChild()!=NULL)
			charDB_ListView->setSelected(charDB_ListView->firstChild(),true);
		
		setDialogState();
	}
}

void DlgConnectionWizard::slotEditPressed()
{
	DlgConnectionWizardInput d(doc,this,"ConnectionWizardInputDialog");
	QString s;
	CharDBEntry* entry;
	CCharacterProfile* prof;
	CMudProfile* mud;

	// Im not satisfied by this code at the moment. It will be reworked when the
	// autologin is reworked again... (ab)

	if (charDB_ListView->currentItem())
	{
		slotShowItem(charDB_ListView->currentItem());

		entry=doc->getEntry(loginShow_Label->text(),mudTitleShow_Label->text());
		
		if (entry!=NULL)
		{
      mud=doc->getMudProfile(entry->mudfile);

      d.setLogin(entry->login);
      d.setMudHost(mud->getHostName());
      s.setNum(mud->getPort());
      d.setMudPort(s);
      d.setMudTitle(mud->getTitle());
      d.setNamePrompt(mud->getNamePrompt());

/*     -> this must be left out, because you can get the password with
          copy and paste otherwise */

//    d.setPassword(entry->password);

      d.setPasswordPrompt(mud->getPasswordPrompt());
      d.setProfile(entry->login+"@"+mud->getTitle());

			prof=doc->getCharacterProfile(entry->profile);
			if ((d.exec()) && (mud!=NULL) && (prof!=NULL))
			{
				entry->ID=d.getLogin()+"@"+d.getMudTitle();
				entry->login=d.getLogin();

				entry->password=d.getPassword();

				s=d.getProfile();
				s=(s.simplifyWhiteSpace()).lower();
				s.replace(QRegExp(" "),"");
				s=s+QString(".prof");
				prof->setFileName(s);
				entry->profile=s;


				s=d.getMudTitle();
				s=(s.simplifyWhiteSpace()).lower();
				s.replace(QRegExp(" "),"");
				s=s+QString(".mud");
				// if title changed look if it is an existing mud, else create new
				if (mud->getFileName()!=s)
				{
					mud = doc->getMudProfile(s); // profile already exists?
					if (mud==NULL)
					{
						mud=new CMudProfile; // if not create new
						doc->insertMudProfile(mud);
					}
					mud->setFileName(s);
					entry->mudfile=s;
				}
				mud->setTitle(d.getMudTitle());
				mud->setHostName(d.getMudHost());
				s=d.getMudPort();
				mud->setPort(s.toUInt());
				mud->setNamePrompt(d.getNamePrompt());
				mud->setPasswordPrompt(d.getPasswordPrompt());

				updateListView();
				if (charDB_ListView->firstChild()!=NULL)
					charDB_ListView->setSelected(charDB_ListView->firstChild(),true);

				setDialogState();
			}
		}
	}
}

void DlgConnectionWizard::slotDeletePressed()
{
	QListViewItem* item;

	item=charDB_ListView->firstChild();

	while (item!=NULL)
	{
		if (charDB_ListView->isSelected(item))
			doc->deleteEntry(QString(item->text(0))+QString("@")+QString(item->text(1)));
		item=item->nextSibling();
	}
	updateListView();

	if (charDB_ListView->firstChild()!=NULL)
		charDB_ListView->setSelected(charDB_ListView->firstChild(),true);

	setDialogState();

}


void DlgConnectionWizard::updateListView()
{
	QString s1,s2;
	QListViewItem* item;
	CharDBEntry* entry;
	CMudProfile* mud;

	charDB_ListView->clear();

	entry=doc->first();


	while (entry!=NULL)
	{
		mud = doc->getMudProfile(entry->mudfile);
		item = new QListViewItem(charDB_ListView, entry->login, mud->getTitle());
		entry=doc->next();
	}
}


void DlgConnectionWizard::slotShowItem(QListViewItem* i)
{
	QFileInfo fi;
	QString s;
	CharDBEntry* entry;
	CMudProfile* mud;
	CCharacterProfile* prof;


	if (i->isSelected())	// selectionChanged can be emmitted, too when
				// item gets unselected !!!
	{
		entry=doc->getEntry(i->text(0),i->text(1));

		if (entry!=NULL)
		{
			loginShow_Label->setText(entry->login);
			mud=doc->getMudProfile(entry->mudfile);
			prof=doc->getCharacterProfile(entry->profile);
			if (mud!=NULL)
			{
				fi.setFile("",prof->getFileName());
				charProfileShow_Label->setText(fi.baseName());
				mudTitleShow_Label->setText(mud->getTitle());
				mudHostShow_Label->setText(mud->getHostName());
				s.setNum(mud->getPort());
				mudPortShow_Label->setText(s);
			}
		}
		setDialogState();
	}
}

QString DlgConnectionWizard::getLogin()
{
	return loginShow_Label->text();
}

QString DlgConnectionWizard::getMudTitle()
{
	return mudTitleShow_Label->text();
}

QString DlgConnectionWizard::getMudHost()
{
	return mudHostShow_Label->text();
}

QString DlgConnectionWizard::getMudPort()
{
	return mudPortShow_Label->text();
}


void DlgConnectionWizard::setDialogState()
{
	QString s;
  bool flag;
	
	s="<";
	s=s+i18n("empty")+">";

	flag=charDB_ListView->currentItem()!=NULL;

	loginShow_Label->setEnabled(flag);
	charProfileShow_Label->setEnabled(flag);
	mudTitleShow_Label->setEnabled(flag);
	mudHostShow_Label->setEnabled(flag);
	mudPortShow_Label->setEnabled(flag);

	edit_Button->setEnabled(flag);
	delete_Button->setEnabled(flag);
	connect_Button->setEnabled(flag);
	apply_Button->setEnabled(flag);
	ping_Button->setEnabled(flag);

	if (!flag){
		loginShow_Label->setText(s);
		charProfileShow_Label->setText(s);
		mudTitleShow_Label->setText(s);
		mudHostShow_Label->setText(s);
		mudPortShow_Label->setText(s);
	}
}

QString DlgConnectionWizard::getSelectedCharacterID()
{
	CharDBEntry* entry;

	entry=doc->getEntry(QString(charDB_ListView->currentItem()->text(0)),QString(charDB_ListView->currentItem()->text(1)));
	return entry->profile;
}


QString DlgConnectionWizard::getSelectedMudID()
{
	CharDBEntry* entry;

	entry=doc->getEntry(QString(charDB_ListView->currentItem()->text(0)),QString(charDB_ListView->currentItem()->text(1)));
	return entry->mudfile;
}

QString DlgConnectionWizard::getPassword()
{

}

void DlgConnectionWizard::slotPingButtonClicked()
{
  if (kmudPing == NULL)
  {
    kmudPing = new KmudPing();

    // FIXXME (2000-10-08, Kevin Krammer): read this from config file
    kmudPing->setExecutable("ping");
  }

  kmudPing->execPingHostDlg(this, mudHostShow_Label->text());
}
