#include "kmaster.h"

PlayGround::PlayGround(QWidget* parent, const char* name) : QWidget(parent, name)
{
  KDNDDropZone* dropZone[4];
  kmasterColors* kmColors = new kmasterColors();

  setMinimumSize(4*FIELD_WIDTH, 300);
  setMaximumSize(4*FIELD_WIDTH, 300);
  
  setBackgroundColor(*(new QColor(67, 183, 183)));

   for(int i = 0; i < 4; i++)
     {
      field[i] = new DropField(this);
      field[i]->setMinimumSize(FIELD_WIDTH, FIELD_WIDTH);
      field[i]->setMaximumSize(FIELD_WIDTH, FIELD_WIDTH);
      field[i]->move(i * FIELD_WIDTH, 0);
      field[i]->setBackgroundColor(*kmColors->kmColor[i]);
      field[i]->colornum = i;
      dropZone[i] = new KDNDDropZone(field[i], DndText);
      connect(dropZone[i], SIGNAL(dropAction(KDNDDropZone*)), field[i], SLOT(dropActionSlot(KDNDDropZone*)));
     }
}

void PlayGround::drawMove()
{
  moveCounter++;
}

void PlayGround::setStartPosition()
{
  moveCounter = 0;

  for(int i = 0; i < 4; i++)
    {
      field[i]->move(i*FIELD_WIDTH, 0);
    }      
}

void PlayGround::paintEvent(QPaintEvent* event)
{
  QPainter p;
  p.begin(this);
  
  if(moveCounter > 0)
    {
      for(int i = 0; i < 4; i++)
	{
	  p.setBrush(field[i]->backgroundColor());
	  //p.drawEllipse(field[i]->x(), field[i]->y(), field[i]->width(), field[i]->height());
	  p.drawEllipse(i*FIELD_WIDTH, (moveCounter-1)*FIELD_WIDTH, FIELD_WIDTH, FIELD_WIDTH);
	}
    }

  p.end();
}

void PlayGround::moveFields()
{
  for(int i = 0; i < 4; i++)
    {
      field[i]->move(field[i]->x(), field[i]->y() + FIELD_WIDTH);
    }
}

