/**********************************************************************

	--- Qt Architect generated file ---

	File: prefinput.cpp
	Last generated: Tue Jul 14 12:55:28 1998

 *********************************************************************/

#include "prefinput.h"
#include <kapp.h>
#include <ksimpleconfig.h>

#define Inherited PrefInputData

PrefInput::PrefInput(QWidget* parent, const char* name)
	:Inherited( parent, name )
{
}


PrefInput::~PrefInput()
{
}


void PrefInput::setPrefs(struct input_prefs *prefs)
{
    checkJoystick->setChecked(prefs->use_joystick);
    checkMouse->setChecked(prefs->use_mouse);
    checkPad->setChecked(prefs->use_pad);
    inputJoystickDevice->setText(prefs->x11joyname);
    inputPadDevice->setText(prefs->towns_pad_name);
}


void PrefInput::writeConfig(struct input_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Input";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (prefs->use_joystick != checkJoystick->isChecked())
        config.writeEntry("use_joystick",checkJoystick->isChecked());
    else
        config.deleteEntry("use_joystick", false);
    if (prefs->use_mouse != checkMouse->isChecked())
        config.writeEntry("use_mouse",checkMouse->isChecked());
    else
        config.deleteEntry("use_mouse", false);
    if (prefs->use_pad != checkPad->isChecked())
        config.writeEntry("use_pad",checkPad->isChecked());
    else
        config.deleteEntry("use_pad", false);
    if (prefs->x11joyname != inputJoystickDevice->text())
        config.writeEntry("x11joyname",inputJoystickDevice->text());
    else
        config.deleteEntry("x11joyname", false);
    if (prefs->towns_pad_name != inputPadDevice->text())
        config.writeEntry("towns_pad_name",inputPadDevice->text());
    else
        config.deleteEntry("towns_pad_name", false);
}


void PrefInput::readConfig(struct input_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Input";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("use_joystick"))
        prefs->use_joystick = config.readNumEntry("use_joystick");
    if (config.hasKey("use_mouse"))
        prefs->use_mouse = config.readNumEntry("use_mouse");
    if (config.hasKey("use_pad"))
        prefs->use_pad = config.readNumEntry("use_pad");
    if (config.hasKey("x11joyname"))
        prefs->x11joyname = config.readEntry("x11joyname");
    if (config.hasKey("towns_pad_name"))
        prefs->towns_pad_name = config.readEntry("towns_pad_name");
}


const QString PrefInput::optionString(struct input_prefs *prefs, const char *cname)
{
    QString
        opt = "",
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Input";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("use_joystick")) {
        if (prefs->use_joystick)
            opt += " -joy";
        else
            opt += " -nojoy";
    }
    if (config.hasKey("use_mouse")) {
        if (prefs->use_mouse)
            opt += " -mouse";
        else
            opt += " -nomouse";
    }
    if (config.hasKey("use_pad")) {
        if (prefs->use_pad)
            opt += " -pad";
        else
            opt += " -nopad";
    }
    if (config.hasKey("x11joyname") && !prefs->x11joyname.isEmpty()) {
        opt += " -x11joyname " + prefs->x11joyname;
    }
    if (config.hasKey("towns_pad_name") && !prefs->towns_pad_name.isEmpty()) {
            opt += " -paddevname " + prefs->towns_pad_name;
    }
    return opt;
}
