/* vp_player.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef VP_PLAYER_H
#define VP_PLAYER_H

#include <qobject.h>
#include <qsignal.h>
#include <qwidget.h>

#include "dummy_player.h"

class KViewPlayer ;

class KGoBoard ;

/**
 * This is KVP_Player. It's used to implement loading
 * and saving for the computer player game.
 *
 * @short   
 **/
class KVP_Player : public KDummyPlayer
{
	Q_OBJECT

public:
	KVP_Player( KViewPlayer *v, bool color,
			KGoBoard *b, QWidget *parent=0,
			const char *name = 0 );
  	~KVP_Player();

protected:
	int load( QDataStream &, KGoBoard * ) ;
	int save( QDataStream & ) ;

	bool canBeSaved() ;
private:
	KViewPlayer *view ;
} ;

#endif
