/* network_player.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef NETWORK_PLAYER_H
#define NETWORK_PLAYER_H

#include <qobject.h>
#include <qsignal.h>
#include "go_player.h"
#include "knetobject.h"

/* for passing messages */
#define MOVE 0
#define QUITTING 1
#define BOARDSIZE 2

class KGoBoard ;

/**
 * This is KNetworkPlayer: a class to make a game over the
 * Internet possible.
 *
 * @short An internet-based implementation of KGoPlayer   
 **/
class KNetworkPlayer : public KGoPlayer
{
	Q_OBJECT

public:
	KNetworkPlayer( KNetObject*, bool color,
			KGoBoard *b, QWidget *parent=0,
			const char *name = 0 );
	~KNetworkPlayer();

public slots:
	void playMove( int, int ) ;
	void boardSetup() ;
	void opponentMoved(int,int) ;
	void illegalMove( int r, int p ) ;

	void connectionBroken() ;
	void messageArrived() ;

private:
	KNetObject *netobject ;

} ;

#endif
