/* KMoveList.cpp
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#include "KMoveList.moc"

#include <qpainter.h>
#include <qkeycode.h>
#include <qprinter.h>
#include "includes.h"

#include "go_board.h"

KMoveList::KMoveList( int r, QWidget *parent,
		const char *name )
		: QTableView( parent, name),
		 rows( r ), offset( 0 ), color_to_add( WHITE )
{
	setFocusPolicy( NoFocus );
//	setBackgroundMode( PaletteBase );
	setNumCols( 2 );
	setNumRows( rows );
	// variable size of rows & columns			
	setCellWidth( 0 );			
	setCellHeight( 0 );

	setTableFlags(
		   Tbl_clipCellPainting |
		   Tbl_smoothScrolling);	
	setAutoUpdate( true ) ; 

	contents = new QString *[rows] ;
	for( int i=0; i<rows; i++)
	{
		contents[i] = new QString [2] ;
	}
	removeAllMoves() ;
}


KMoveList::~KMoveList()
{
	for( int i=0; i<rows; i++)
		delete [] contents[i] ;
	delete [] contents;
}

int KMoveList::cellWidth(int)
{
	return ((size().width())/2) ;
}

int KMoveList::cellHeight(int)
{
	return ((size().height())/rows) ;
}

const char* KMoveList::cell( int row, int col )
{
    return contents[ indexOf( row ) ][col].data() ;
}



void KMoveList::setCell( int row, int col, QString s )
{
	contents[ indexOf( row ) ][col] = s ;
	updateCell( row, 0, true );
	updateCell( row, 1, true );
}

void KMoveList::addMove( QString s )
{
	if( color_to_add==WHITE )
	{
		for( int i=0; i<sizeOfList()-1 ; i++ )
		{
			setCell( i, 0, cell( i+1, 0 ) ) ;
			setCell( i, 1, cell( i+1, 1 ) ) ;
		}
		setCell( sizeOfList()-1, 0, s ) ;
	}
	else
	{
		setCell( sizeOfList()-1, 1, s ) ;
	}
	switchColor() ;
	repaint() ;
}

void KMoveList::addMoveWhite( QString s )
{
	color_to_add = WHITE ;
	addMove( s ) ;
}

void KMoveList::addMoveBlack( QString s )
{
	color_to_add = BLACK ;
	addMove( s ) ;
}

void KMoveList::removeAllMoves()
{
	for( int i=0;i<rows;i++)
	{
		contents[i][0]=QString("") ;
		contents[i][1]=QString("") ;
	}
}

void KMoveList::switchColor()
{
	color_to_add = ( color_to_add==BLACK )?WHITE:BLACK ;
}

void KMoveList::paintCell( QPainter* p, int row, int col )
{
	int w = cellWidth(0);
	int h = cellHeight(0);

	// Draw cell contents (text)
	p->drawText( 0, 0, w-1, h-1,
		AlignLeft, contents[indexOf(row)][col].data(),
			contents[indexOf(row)][col].length() );
}

int KMoveList::indexOf( int row )
{
    return (( offset + row)%rows) ;
}

int KMoveList::sizeOfList()
{
    return (rows) ;
}
