#include <kmsgbox.h>
#include <qstring.h>
#include <unistd.h>

#include "engine.h"
#include "kchesswidget.h"

Engine::Engine(const char *chessProg, KChessWidget *_w)
	: w(_w)
{
	// Make sure that the chess engine exits when we die
	setsid();

	proc = new KProcess;

	*proc << chessProg;

	connect(proc, SIGNAL(processExited(KProcess *)),
			this, SLOT(EngineDone(KProcess*)));

	connect(proc, SIGNAL(receivedStdout(KProcess *, char*, int)),
			this, SLOT(readStdout(KProcess*, char*, int)));

	bool result = proc->start(KProcess::NotifyOnExit , KProcess::All);
		
	if (!result) {
		QString str;
		str.sprintf("Couldn't start the chess program: %s",
					chessProg);

		KMsgBox::message(NULL, "KChess", str.data());
	}

	Engine::write("xboard\nnew\n");
}

void 
Engine::readStdout(KProcess *proc, char *buffer, int buflen)
{
	char *b = new char[buflen+1];

	strncpy(b, buffer, buflen);
	b[buflen] = '\0';

	cout << "received: " << b << endl;

	if (strncmp(buffer, "move", 4))
		return;

	// skip over "move "
	buffer = b+5;

	// update the board
	w->makeMove(buffer);

	delete b;
}

void 
Engine::EngineDone(KProcess *proc)
{
	//cout << "Chess program exited" << endl;
}
