/***************************************************************************
                          kbubblesHighscore.cpp  -  description
                             -------------------
    begin                : Tue Jan 4 2000
    copyright            : (C) 2000 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbubblesHighscore.h"

// KDE
#include <kapp.h>

// QT
#include <qfile.h>
#include <qfont.h>
#include <qlabel.h>
#include <qcolor.h>
#include <iostream.h>
#include <qaccel.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlineedit.h>

// OTHER
#include "global.h"

KbubblesHighscore::KbubblesHighscore(QWidget* parent=0, const char *name=0, bool modal=TRUE)
	: QDialog(parent,name,modal)
{

}

int KbubblesHighscore::check_highscore( int points, char *fname)	
{
	int new_value = 0;
	int place=11;
	int i = 0;
	struct hscore highscore[11];
	QFile f(fname);
	if (!f.exists()) {
		new_value = 1;
		place = 0;
		i = 1;
	}	else {
		if ( !(f.open(IO_ReadOnly)) )
	  	exit(15);
		while (!(f.atEnd()) && i < 11 ) {
			f.readBlock((char *) &highscore[i], sizeof(struct hscore) );
			if ((new_value != 1) && (points > highscore[i].points)) {
				new_value = 1;
				place = i;
				i++;
				strcpy(highscore[i].name, highscore[place].name);
				highscore[i].points = highscore[place].points;
			}
			i++;
		}
		f.close();
	}
	if ( (place > 10) && (i < 10) ) {
		place = i;
		i++;
		new_value = 1;
	}
	if (!(new_value)) {
		return 0;
	}
	QMessageBox *msg = new QMessageBox(	i18n("Highscore"),"",QMessageBox::NoIcon,1,0,0,
																		 	this->parentWidget(),"msgbox",TRUE);
	QLabel *lab = new QLabel(i18n("Name:"), msg, "label");
	lab->setAutoResize(TRUE);
	lab->move(10,15);
	lab->show();
	QLineEdit *ledit = new QLineEdit(msg, "ledit");
	ledit->setMaxLength(9);
	ledit->move(lab->x()+lab->width()+5,lab->y()-5);
	ledit->show();
	ledit->setFocus();
	connect(ledit,SIGNAL(returnPressed()),msg,SLOT(hide()));
	msg->resize(10+lab->width()+5+ledit->width()+10,10+ledit->height()+50);
	msg->show();
	strcpy(highscore[place].name, ledit->text());
	highscore[place].points = points;
	if (i == 11)
		i--;
	f.open(IO_WriteOnly);
	for (int j = 0; j < i; j++) {
		f.writeBlock((char *) &highscore[j], sizeof(struct hscore) );
	}
	f.flush();
	f.close();
	this->show_highscore(fname);
	return (place + 1);
}

void KbubblesHighscore::show_highscore(char *fname)
{
	this->setCaption(i18n("Highscores"));
//	this->grabKeyboard();
	QFile f(fname);
	struct hscore new_score;
	if (!f.open(IO_ReadOnly)) {
		QMessageBox::information(this->parentWidget(), i18n("Highscore"), i18n("No highscore file found"));
		return;
	}
	int i = 1;
	QString hscorestr;
	while (!f.atEnd()) {
		f.readBlock((char *) &new_score, sizeof(struct hscore));
		if (hscorestr.isNull()) {
			hscorestr.sprintf("%3d %10s\t%8d\n", i, new_score.name, new_score.points);
    } else {
			hscorestr.sprintf("%s%3d %10s\t%8d\n", hscorestr.data(), i, new_score.name, new_score.points);
		}
		i++;
	}
	f.close();
	
	QFont font;
  font.setPointSize(24);
  font.setWeight( QFont::Bold );
  QString hscorename = f.name();
  hscorename = hscorename.right(hscorename.length()-hscorename.findRev('/',hscorename.length())-1);
	hscorename = hscorename.left(hscorename.find('.',0));
	QLabel *hscorefile = new QLabel(hscorename.data(), this, "Filename");
	hscorefile->setBackgroundColor(QColor::QColor("blue"));
  hscorefile->setFont(font);
  hscorefile->move(5,5);
	hscorefile->setAutoResize(TRUE);
	hscorefile->show();	
	
	QLabel *score = new QLabel(hscorestr.data(), this, "Score label");
	score->setBackgroundColor(QColor::QColor("blue"));
  font.setPointSize(16);
  font.setWeight( QFont::Bold );
  score->setFont(font);
  score->move(hscorefile->x(),hscorefile->y()+hscorefile->height() + 5);
	score->setAutoResize(TRUE);
	score->show();
	this->setFixedSize( (hscorefile->width() > score->width() ? hscorefile->width() : score->width()) + 10,
								5+hscorefile->height()+5+score->height()+5);
	this->setBackgroundColor(QColor::QColor("blue"));
	this->show();
}

KbubblesHighscore::~KbubblesHighscore()
{
}

void KbubblesHighscore::keyReleaseEvent(QKeyEvent *key)
{
	this->hide();
}
