/***************************************************************************
                          ref.h  -  description                        
                           -------------------                 

    version              :                                   
    begin                :                                            
    copyright            : (C)  by Alessandro Praduroux 
    email                : pradu@geocities.com                              
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef REF_H
#define REF_H
#include <assert.h>

template <class T>
class Ref
{
  T * ptr;
 public:
  Ref(const T* _ptr = 0 ): ptr((T*)_ptr) {}
  T* operator->() const {assert(ptr); return ptr;}
  T* get() const {return ptr;}
  T& operator*() const {assert(ptr); return *ptr;}
};


template <class T> inline bool operator==(const Ref<T>& x, const Ref<T>& y)
{ 
  return x.get()== y.get(); 
}

template <class T> inline bool operator<(const Ref<T>& x, const Ref<T>& y) 
{
  return x.get()< y.get(); 
}

#endif //REF_H
