/***************************************************************************
                          kship.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 3 1999                                           
    copyright            : (C) 1999 by pradu                         
    email                : pradu@geocities.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kship.h"
#include <iostream.h>
#include <qpainter.h>

KShip::KShip(int _size, int _dir , const QPoint & p)
	: dir(_dir), size(_size)
{
	hits = 0;
	base.setTop(p.x());
	base.setLeft(p.y());

	switch (dir)
		{
			case NS:
				base.setWidth(1);
				base.setHeight(size);
				break;
			case WE:
				base.setWidth(size);
				base.setHeight(1);
				break;
			default:
				break;
		}
}

KShip::~KShip()
{
}

/**  */
bool KShip::hitTest(QPoint &p)
{
	if (base.contains(p))
		hits++;
	return base.contains(p);		
}


/**  */
bool KShip::outOfBounds()
{
	return (base.bottom() > 14) || (base.right() > 14);
}



/**  */
void KShip::paint(QPainter *p)
{
  int x, y, w = 20, h = 20;
  QPen penBlack(black);
  QBrush redBrush(red);

  p->setPen(penBlack);

  int dim = base.size().width() + base.size().height() - 1;

  for (int i = 0; i < dim; i++)
    {
      x = base.top() * 20 + 10;
      y = base.left() * 20 + 10;
      if (dir==NS)
        x += i * 20;
      else
        y += i * 20;

      p->fillRect(x, y, w, h, redBrush);
    }

}

/**  */
bool KShip::intersects(const KShip *s) const
{
	return base.intersects(s->base);
}

/**  */
bool KShip::destroyed()
{
	return hits == size;
}
