/***************************************************************************
                       MCQueryDlg.h  -  multiple choice query dialog
                             -------------------
    begin                : Thu Nov 25 11:45:53 MET 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "MCQueryDlg.h"
#include "QueryDlg.h"
#include "resource.h"
#include "kvoctraindoc.h"
#include "QueryManager.h"
#include "ProgressChart.h"
#include "kvoctrain.h"
#include "eadebug.h"

#include <kapp.h> 

#include <qtimer.h>
#include <qkeycode.h>

#include <iostream.h>
#include <algo.h>

#include "compat_2x.h"

#define MAX_TRANS  5  // select one out of x

MCQueryDlg::MCQueryDlg(QString org,
                   QString trans,
                   int entry,
                   int orgcol,
                   int transcol,
                   int q_cycle,
                   int q_num,
                   int q_start,
                   kvoctrainExpr *exp,
                   kvoctrainApp  *app,
                   kvoctrainDoc  *doc,
                   int mqtime,
                   QWidget *parent,
                   char *name)
	: MCQueryDlgData(parent,name)
{
        qtimer = 0;
	setCaption (QString(KVOCTRAIN_TITLE) + ": " + i18n("Multiple choice"));
        setQuery (org, trans, entry, orgcol, transcol,
                  q_cycle, q_num, q_start,
                  exp, app, doc, mqtime);
        setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


void MCQueryDlg::setQuery(QString org,
                         QString trans,
                         int entry,
                         int orgcol,
                         int transcol,
                         int q_cycle,
                         int q_num,
                         int q_start,
                         kvoctrainExpr *exp,
                         kvoctrainApp  *app,
                         kvoctrainDoc  *doc,
                         int mqtime)
{
   kv_app = app;
   kv_doc = doc;
   q_row = entry;
   q_ocol = orgcol;
   q_tcol = transcol;
   translation = trans;
   showCounter = 0;
   orgField->setText (org);
   show_it->setDefault(true);
   QString s;
   s.setNum (q_cycle);
   progCount->setText (s);
   remark->setText (exp->getRemark(orgcol));
   falseFriend->setText (exp->getFauxAmi(orgcol));
   progChart->setData (q_start, q_num);
   progChart->repaint();

   type->setText ("");
   vector<TypeRelation> all_types = QueryManager::getRelation(false);
   for (int i = 0; i < (int) all_types.size(); i++) {
     if ( exp->getType(orgcol) == all_types[i].shortStr())
       type->setText(all_types[i].longStr());
   }

   if (mqtime >= 1000) { // more than 1000 milli-seconds
     if (qtimer == 0)
       qtimer = new QTimer( this );
     connect( qtimer, SIGNAL(timeout()), this, SLOT(timeoutReached()) );
     qtimer->start(mqtime, TRUE);
   }

   vector<QString> strings;
   button_ref.clear();
   button_ref.push_back(trans1);
   button_ref.push_back(trans2);
   button_ref.push_back(trans3);
   button_ref.push_back(trans4);
   button_ref.push_back(trans5);
   random_shuffle(button_ref.begin(), button_ref.end() );
   solution = 0;

   if (doc->numEntries() <= MAX_TRANS) {
     for (int i = 0; i < doc->numEntries(); i++ ) {
       kvoctrainExpr *act = doc->getEntry(i);
       if (q_tcol == 0)
         strings.push_back(act->getOriginal());
       else 
         strings.push_back(act->getTranslation(q_tcol));

       if (act == exp)
         solution = i;
     }
   }
   else {
     vector<kvoctrainExpr*> exprlist;
     solution = 0;
     exprlist.push_back(exp);

     srand((unsigned int)time((time_t *)NULL));
     int count = MAX_TRANS-1;
     // gather random pointers for the choice
     while (count > 0) {
       int nr = (int) (doc->numEntries() * ((1.0*rand())/RAND_MAX));
       // append if new in list
       bool newex = true;
       for (int i = 0; newex && i < (int) exprlist.size(); i++) {
         if (exprlist[i] == doc->getEntry(nr))
           newex = false;
       }
       if (newex) {
         count--;
         exprlist.push_back(doc->getEntry(nr));
       }
     }

     for (int i = 0; i < (int) exprlist.size(); i++) {
       if (q_tcol == 0)
         strings.push_back(exprlist[i]->getOriginal());
       else
         strings.push_back(exprlist[i]->getTranslation(q_tcol));
     }

   }
   for (int i = strings.size(); i < MAX_TRANS; i++ )
     strings.push_back("");

   if (solution >= MAX_TRANS) {
       solution = 0;
       KDEBUG (KDEBUG_ERROR, 0,
               "ctor MCQueryDlg: solution out of range\n");
   }

   button_ref[0]->setEnabled(!strings[0].isEmpty() );
   button_ref[1]->setEnabled(!strings[1].isEmpty() );
   button_ref[2]->setEnabled(!strings[2].isEmpty() );
   button_ref[3]->setEnabled(!strings[3].isEmpty() );
   button_ref[4]->setEnabled(!strings[4].isEmpty() );

   button_ref[0]->setText(strings[0]);
   button_ref[1]->setText(strings[1]);
   button_ref[2]->setText(strings[2]);
   button_ref[3]->setText(strings[3]);
   button_ref[4]->setText(strings[4]);

   trans1->setText (QString("&1: ")+trans1->text() );
   trans2->setText (QString("&2: ")+trans2->text() );
   trans3->setText (QString("&3: ")+trans3->text() );
   trans4->setText (QString("&4: ")+trans4->text() );
   trans5->setText (QString("&5: ")+trans5->text() );

   trans1->setChecked (false);
   trans2->setChecked (false);
   trans3->setChecked (false);
   trans4->setChecked (false);
   trans5->setChecked (false);

   show_it->setFocus();
}


void MCQueryDlg::initFocus() const
{
  trans1->setFocus();
}


void MCQueryDlg::optionsClicked()
{
   emit sigOptions();
}


void MCQueryDlg::showItClicked()
{
  resetButton(button_ref[0]);
  resetButton(button_ref[1]);
  resetButton(button_ref[2]);
  resetButton(button_ref[3]);
  resetButton(button_ref[4]);

  button_ref[solution]->setFocus();
  button_ref[solution]->setChecked(true);
  dont_know->setDefault(true);
}


void MCQueryDlg::verifyClicked()
{

  bool known = false;
  if (solution == 0)
    known = button_ref[0]->isChecked ();
  if (solution == 1)
    known = button_ref[1]->isChecked ();
  if (solution == 2)
    known = button_ref[2]->isChecked ();
  if (solution == 3)
    known = button_ref[3]->isChecked ();
  if (solution == 4)
    known = button_ref[4]->isChecked ();

  if (button_ref[0]->isChecked() ) {
    verifyButton(button_ref[0], known);
    resetButton(button_ref[1]);
    resetButton(button_ref[2]);
    resetButton(button_ref[3]);
    resetButton(button_ref[4]);
  }
  else if (button_ref[1]->isChecked() ) {
    resetButton(button_ref[0]);
    verifyButton(button_ref[1], known);
    resetButton(button_ref[2]);
    resetButton(button_ref[3]);
    resetButton(button_ref[4]);
  }
  else if (button_ref[2]->isChecked() ) {
    resetButton(button_ref[0]);
    resetButton(button_ref[1]);
    verifyButton(button_ref[2], known);
    resetButton(button_ref[3]);
    resetButton(button_ref[4]);
  }
  else if (button_ref[3]->isChecked() ) {
    resetButton(button_ref[0]);
    resetButton(button_ref[1]);
    resetButton(button_ref[2]);
    verifyButton(button_ref[3], known);
    resetButton(button_ref[4]);
  }
  else if (button_ref[4]->isChecked() ) {
    resetButton(button_ref[0]);
    resetButton(button_ref[1]);
    resetButton(button_ref[2]);
    resetButton(button_ref[3]);
    verifyButton(button_ref[4], known);
  }

  if (known)
    know_it->setDefault(true);
  else
    dont_know->setDefault(true);
}


void MCQueryDlg::knowItClicked()
{
   done (Known);
}


void MCQueryDlg::timeoutReached()
{
   done (Timeout);
}


void MCQueryDlg::dontKnowClicked()
{
   done (Unknown);
}


void MCQueryDlg::stopItClicked()
{
   done (StopIt);
}


void MCQueryDlg::editOrgClicked()
{

   if (qtimer != 0)
     qtimer->stop();

   emit sigEditEntry (q_row, KV_COL_ORG+q_ocol);
}


void MCQueryDlg::editTransClicked()
{

   if (qtimer != 0)
     qtimer->stop();

   emit sigEditEntry (q_row, KV_COL_ORG+q_tcol);
}


void MCQueryDlg::keyPressEvent( QKeyEvent *e )
{
  switch( e->key() )
  {
    case Key_Escape:
      dontKnowClicked();
    break;
      
    case Key_Return:
    case Key_Enter:
      if (dont_know->isDefault() )
        dontKnowClicked();
      else if (know_it->isDefault() )
        knowItClicked();
      else if (show_it->isDefault() )
        showItClicked();
    break;
      
    default:
      e->ignore();
    break;
  }
}


void MCQueryDlg::trans1clicked()
{
  resetButton(button_ref[0]);
  resetButton(button_ref[1]);
  resetButton(button_ref[2]);
  resetButton(button_ref[3]);
  resetButton(button_ref[4]);
}


void MCQueryDlg::trans2clicked()
{
  resetButton(button_ref[0]);
  resetButton(button_ref[1]);
  resetButton(button_ref[2]);
  resetButton(button_ref[3]);
  resetButton(button_ref[4]);
}


void MCQueryDlg::trans3clicked()
{
  resetButton(button_ref[0]);
  resetButton(button_ref[1]);
  resetButton(button_ref[2]);
  resetButton(button_ref[3]);
  resetButton(button_ref[4]);
}


void MCQueryDlg::trans4clicked()
{
  resetButton(button_ref[0]);
  resetButton(button_ref[1]);
  resetButton(button_ref[2]);
  resetButton(button_ref[3]);
  resetButton(button_ref[4]);
}


void MCQueryDlg::trans5clicked()
{
  resetButton(button_ref[0]);
  resetButton(button_ref[1]);
  resetButton(button_ref[2]);
  resetButton(button_ref[3]);
  resetButton(button_ref[4]);
}

