/***************************************************************************
                AdjQueryDlg.h  -  query dialog for adjectives
                             -------------------
    begin                : Sat Dec 4 15:09:18 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef AdjQueryDlg_included
#define AdjQueryDlg_included

#include "AdjQueryDlgData.h"
#include "GrammerManager.h"

class AdjQueryDlg : public AdjQueryDlgData
{
    Q_OBJECT

public:

    AdjQueryDlg
    (
        QString type,
        int entry,
        int col,
        int query_cycle,
        int query_num,
        int query_startnum,
        kvoctrainExpr *exp,
        kvoctrainApp  *kv_app,
        kvoctrainDoc  *doc,
        const Comparison &comp,
        int   mtime,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual void setQuery (QString type,
                int entry,
                int col,
                int query_cycle,
                int query_num,
                int query_startnum,
                kvoctrainExpr *exp,
                kvoctrainApp  *kv_app,
                kvoctrainDoc  *doc,
                const Comparison &comp,
                int   mtime);

    virtual ~AdjQueryDlg();

public slots:
    virtual void initFocus() const;

protected:
    void keyPressEvent( QKeyEvent *e );
    void resetAllFields();

protected slots:

    virtual void lev1Changed(EA_QTSTR);
    virtual void lev2Changed(EA_QTSTR);
    virtual void lev3Changed(EA_QTSTR);
    virtual void stopItClicked();
    virtual void showAllClicked();
    virtual void editClicked();
    virtual void knowItClicked();
    virtual void returnPressed();
    virtual void dontKnowClicked();
    virtual void optionsClicked();
    virtual void verifyClicked();
    virtual void timeoutReached();

protected:

    Comparison  comp;
};
#endif // AdjQueryDlg_included
