/* -*- C++ -*-

  $Id: XmlTokenizer.h,v 1.2 1998/07/16 12:04:19 sattler Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  modified for kvoctrain by Ewald Arnold ewald@ewald-arnold.de in April 99

*/

#ifndef XmlTokenizer_h_
#define XmlTokenizer_h_

#include <iostream.h>

#include <qstring.h>

/**
 * The XMLTokenizer class allows an application to break a XML stream 
 * into tokens.
 *
 * @short     A class for tokenizing an XML stream.
 * @author    Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)
 * @version   $Id: XmlTokenizer.h,v 1.2 1998/07/16 12:04:19 sattler Exp $
 */
class XmlTokenizer {
public:
  /**
   * The expected tokens for a XML stream.
   */
  enum Token { Tok_Invalid,
	       Tok_EOF, 
	       Tok_Symbol, 
	       Tok_String, 
	       Tok_Text, 
	       Tok_Comment, 
	       Tok_Lt,       /* < */
	       Tok_Gt,       /* > */
	       Tok_QSign,    /* ? */
	       Tok_Eq,       /* = */
	       Tok_Slash,    /* / */
	       Tok_Exclam,   /* ! */
	       Tok_Bar,      /* | */
	       Tok_LParen,   /* ( */
	       Tok_RParen,   /* ) */
	       Tok_LBracket, /* [ */
	       Tok_RBracket, /* ] */
	       Tok_Plus,     /* + */
	       Tok_Asterisk, /* * */
	       Tok_Comma,    /* , */
	       Tok_Semicolon,/* ; */
	       Tok_NSign,    /* # */
	       Tok_Apostr,   /* ' */
	       Tok_Percent   /* % */
	       };

  /**
   * Create a XmlTokenizer instance for the given input stream.
   *
   * @param is   The open input stream for reading.
   */
  XmlTokenizer (istream& is);

  /**
   * Destructor.
   */
  ~XmlTokenizer ();

  /**
    * Return the next token from the stream.
   * @return       The next token from the stream.
   */
  Token nextToken ();

  /**
   * Return the string representation of the current token.
   *
   * @return  The string representation.
   */
  const QString& element ();

  /**
   * Cause the next call to method <tt>nextToken</tt> of this tokenizer 
   * to return the current token.
   */
  void unget ();

  int lineNumber() { return lineno; }

protected:
  void skipWhitespace ();
  Token readString ();
  Token readSymbol ();
  Token readText ();
  Token readComment ();

private:
  istream strm;
  QString elem;
  Token last_tok;
  bool use_last;
  bool is_open;
  int  lineno;
};

#endif
