/***************************************************************************
                    kva_clip.cpp  - clipboard part of kvoctrain
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kvoctrain.h"

#include <qclipboard.h>
#include <klined.h>

void kvoctrainApp::clipboardChanged() {
  QString s = QApplication::clipboard()->text();
  edit_menu->setItemEnabled(ID_EDIT_PASTE,  !s.isEmpty());
  edit_menu->setItemEnabled(ID_SEARCH_CLIP, !s.isEmpty());
  toolBar()->setItemEnabled(ID_EDIT_PASTE,  !s.isEmpty());
  toolBar()->setItemEnabled(ID_EDIT_PASTE,  !s.isEmpty());
#if defined(_WS_X11_)
//  disconnect(QApplication::clipboard(),SIGNAL(dataChanged()),
//    this,SLOT(clipboardChanged()));
#endif
}


void kvoctrainApp::slotSmartSearchClip()
{
  QString s;
  QString entries = QApplication::clipboard()->text();

  if (!entries.isEmpty()) {
    int pos = entries.find ('\n'); // search for a line end
    if (pos < 0)
      pos = entries.find ('\r');

    if (pos < 0)    // just first "line"
      s = entries;
    else
      s = entries.left(pos);

    searchpos = 0;                      // search from beginning
    searchstr = s.stripWhiteSpace();    // in case RETURN is pressed
    searchLine->setFocus();
    searchLine->setText (searchstr);
  }
}


void kvoctrainApp::aboutToShowEdit() {
  QString s = QApplication::clipboard()->text();
  edit_menu->setItemEnabled(ID_CLR_SEL,  tagCount != 0);
  edit_menu->setItemEnabled(ID_SAVE_ROW,  tagCount != 0);
  edit_menu->setItemEnabled(ID_EDIT_PASTE,  !s.isEmpty());
  edit_menu->setItemEnabled(ID_SEARCH_CLIP, !s.isEmpty());
  toolBar()->setItemEnabled(ID_SEARCH_CLIP, !s.isEmpty());
  toolBar()->setItemEnabled(ID_EDIT_PASTE,  !s.isEmpty());
}


void kvoctrainApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));

  QApplication::setOverrideCursor( waitCursor );
  QString exp;
  QString s;

  if (tagCount == 0) {

    kvoctrainExpr *expr = view->getTable()->selectedRow();
    if (expr == 0 ) return;

// same block in kvd_csv.cpp::saveToCsv()
  
    if (paste_order.count() != 0) {
      // now concat columns according to paste-order
      for (int i = 0; i < (int) paste_order.count() && i < doc->numLangs(); i++) {
        int j;
        if ((j = doc->findIdent(paste_order.at(i))) >= 0) {
          if (j == 0)
            s = expr->getOriginal();
          else
            s = expr->getTranslation(j);
  
          if (i != 0 )
            exp += separator;
          exp += s;
        }
      }
  
    }
    else {
      exp = expr->getOriginal();
      for (int i = 1; i <= expr->numTranslations(); i++) {
        exp += separator;
        exp += expr->getTranslation(i);
      }
    }
  }
  else {

    for (int i = 0; i < doc->numEntries(); i++) {
      kvoctrainExpr *expr = doc->getEntry(i);
      if (expr->isTagged()) {
        if (paste_order.count() != 0) {
          // now concat columns according to paste-order
          for (int i = 0; i < (int) paste_order.count() && i < doc->numLangs(); i++) {
            int j;
            if ((j = doc->findIdent(paste_order.at(i))) >= 0) {
              if (j == 0)
                s = expr->getOriginal();
              else
                s = expr->getTranslation(j);
      
              if (i != 0 )
                exp += separator;
              exp += s;
            }
          }
      
        }
        else {
          exp += expr->getOriginal();
          for (int i = 1; i <= expr->numTranslations(); i++) {
            exp += separator;
            exp += expr->getTranslation(i);
          }
        }
        exp += "\n";
      }
    }
  }

  if (!exp.isEmpty()) {
#if defined(_WS_X11_)
//    disconnect(QApplication::clipboard(),SIGNAL(dataChanged()),this,0);
#endif
    QApplication::clipboard()->setText(exp);
#if defined(_WS_X11_)
//    connect(QApplication::clipboard(),SIGNAL(dataChanged()), this,SLOT(clipboardChanged()));
#endif
  }

  QApplication::restoreOverrideCursor();
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));

  QApplication::setOverrideCursor( waitCursor );
  QString s;
  QString entries = QApplication::clipboard()->text();

  bool changed = false;
  QString num;
  view->setView(0, langset, gradecols);
  while (!entries.isEmpty()) {
    int pos = entries.find ('\n'); // search for a line end
    if (pos < 0) {
      pos = entries.find ('\r');   // mac style ?
    }

    if (pos < 0) {
      s = entries;
      entries = "";
    }
    else {
      s = entries.left(pos);
      entries.remove (0, pos+1);
    }

    // same block in kvd_csv.cpp::loadFromCsv()

    if (!s.stripWhiteSpace().isEmpty()) {
      if (paste_order.count() != 0) {
        kvoctrainExpr bucket (s, separator, act_lesson);
        kvoctrainExpr expr;
        expr.setLesson(act_lesson);
        // now move columns according to paste-order
        for (int i = 0; i < (int) paste_order.count() && i < doc->numLangs(); i++) {
          if (doc->findIdent(paste_order.at(i)) >= 0) {
            int j = doc->findIdent(paste_order.at(i));
            QString s;
            if (i == 0)
              s = bucket.getOriginal();
            else
              s = bucket.getTranslation(i);

            if (j == 0)
              expr.setOriginal(s);
            else
              expr.setTranslation(j, s);
          }
        }
        changed = true;
        doc->appendEntry (&expr);
      }
      else {
        kvoctrainExpr expr (s, separator, act_lesson);
        changed = true;
        doc->appendEntry (&expr);
      }
    }
  }

  if (changed) {
    doc->setModified();
    view->setView(doc, langset, gradecols);
    view->getTable()->setCurrentRow (view->getTable()->numRows()-1, KV_COL_ORG);
    view->getTable()->updateViewPort();
  }

  QApplication::restoreOverrideCursor();
  slotStatusMsg(IDS_DEFAULT);
}


