/***************************************************************************
                          vvokabelliste.h  -  description
                             -------------------
    begin                : Tue Dec 7 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VVOKABELLIST_H
#define VVOKABELLIST_H

#include <qlist.h>
#include "vvokabel.h" 

#define VokSeparator '\t'
/**implements the list of vocabels 
  *@author Friedrich W. H. Kossebau
  */

typedef QList<VVokabel> VVokabelListBase;   
typedef QListIterator<VVokabel> VVokabelListIterator;

enum VSortKey {SortTerm, SortTranslation, SortTyp, SortLevel}; 
  
class VVokabelList : public VVokabelListBase 
{
  public: 
	  VVokabelList() : SortKey( SortLevel )  {}
  	~VVokabelList() {}
    
    /** inserts new vocabel in list, data is seperated by tabs, term translation remark knowledge */
    VVokabel *newVokabel ( QString Data = 0 );
    /** returns textline of next vokabel in the list to the current vokabel */
    QString nextLine() { return line( next() ); }
    /** returns textline of first vokabel of vokabellist */
    QString firstLine() { return line( first() ); }
    /** returns textline for output*/
    QString line( VVokabel * ) const;
    
    /** sets the key for sorting to NewKey, standard is SortLevel that cares of knowledge*/
    void setSortKey( VSortKey NewKey = SortLevel ) { SortKey = NewKey; }
    /** */
    VSortKey sortKey() { return SortKey; }
  	
  protected: // Protected methods
    /**  */
    virtual int compareItems( GCI V1, GCI V2 );
    
  private:
    VSortKey SortKey;
};

#endif
