#ifndef KPSQLMAN_H
#define KPSQLMAN_H

#include <kapp.h>
#include <kconfig.h>
#include <ktopwidget.h>
#include <kiconloader.h>
#include <kstdaccel.h>
#include <kmsgbox.h>
#include <kconfig.h>

#include <stdlib.h>
#include <unistd.h>

#include <qframe.h>
#include <qlayout.h>
#include <qkeycode.h>
#include <qlined.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qmlined.h>

#include <ktabctl.h>

#include "sKTreeList.h"
#include "conf_dlg.h"
#include "SQL.h"


// -- class MApp-------------------------------

class MApp: public KTopLevelWidget 
{
  Q_OBJECT
public:
  MApp(const char *name = 0);
  ~MApp();
    OutPutResults(PGresult*);
    int FillTree();
protected:
  KMenuBar	*menubar;
  KStatusBar	*statusbar;
  KToolBar	*toolbar;
  sKTreeList    *tree;
  QGridLayout   *mainLayout;
  QWidget       *w;

SQLQuerier  sql;
QStrList strlist;

//-----
 KTabCtl  *tabctl;
 QMultiLineEdit *QueryMLE;
 QMultiLineEdit *ResultsMLE;
 
  QPopupMenu	*file, *help, *conf, *pop;

bool mouseRightButDown;

protected slots:
  void slotNew();
  void slotRead();
  void slotReadSystem();
  void slotWriteQuery();
  void slotWriteResults();
  void slotExit();
  void slotItemPoppedUp(int);
  void slotHelp();
  void slotExecQuery();
  void tree_clicked(QMouseEvent*);
  void slotChangeExpColl(int);
  void slotConfigure();
  void slotComboSelected();
  void slotSaveConfig();

private:
  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupTabCtl();
  void setupTree();
};

#endif KPSQLMAN_H
