#include "config.h"
#include "libpq-fe.h"
#include "KResultBox.h"

// geisler@primus.baynet.de
// Sat May 23 14:51:46 MEST 1998

#ifndef SQL_H
#define SQL_H

class sql
{
  char *sql_statement;                // sql-statement
  PGconn *conn;                       // connection to database
  PGresult *res;                      // result after db_execute
  int nFields;                        // number of fields
  char *PGHOST;
  char *PGPORT;
  char *PGUSER;
  char *PGPASSWORD;
  char *PGTTY;
  char *PGDATABASE;
  char *PGOPTIONS;
  KResultBox *box;

public:
  sql();                              // constructor
  ~sql();                             // destructor
  void setData(char *, char *, char *, char *, char *, KResultBox *);
  void db_connect();                  // make connection to database
  char *db_execute();                 // make normal execute
  int db_execute_transaction();       // make transaction execute
  int db_exit();                      // exit from database
  void db_clear();                    // clear res
  void reload(char *);                // reload sql-statement
  void db_printresult();              // print result
};

#endif
