#ifndef K_STRING_H
#define K_STRING_H

#include <string>

class KString: public string
{
	public:
	KString(const KString & kString): string(kString){};
	KString( ): string(){};
	KString( const string &aString ): string(aString){};
	KString( int  anInt );
	KString( unsigned  anUnsigned );
	KString( long  aLong );
	KString( unsigned long  anUnsignedLong );
	KString( short  aShort );
	KString( unsigned short  anUnsignedShort );
	KString( double  aDouble );
	KString( char  aChar );
	KString( unsigned char  anUnsignedChar );
	KString( signed char  aSignedChar);
	KString( const char  *pChar ): string(pChar){};
	KString( const signed char  *pSignedChar);
	KString( const char  *pSignedChar, int len);
	virtual ~KString(){};

	KString& strip();
	KString& translate(const KString& strToChange,
                           const KString& strNew);
	int numWords(char pad=' ') const;
	KString word(unsigned startWord, char pad=' ');
	KString words(unsigned startWord,
                       unsigned endWord = KString::npos,
                       char pad=' ');
	KString& upperCase();
	KString& lowerCase();
	KString mid(int start, int length);
	bool isDigits() const;
	int occurrencesOf(const KString& str) const;
	bool isAlphabetic() const;
	KString upper() const;
	bool isEmpty() const;

	operator const char*() {return this->c_str();}
	operator const char*() const {return this->c_str();}

/*	const char& operator[](int p) const {return string::operator[](p);}
	char& operator[](int p) {return string::operator[](p);}
	const char& operator[](long p) const {return string::operator[](p);}
	char& operator[](long p) {return string::operator[](p);}
	const char& operator[](unsigned p) const {return string::operator[](p);}
	char& operator[](unsigned p) {return string::operator[](p);}
	const char& operator[](unsigned long p) const {return string::operator[](p);}
	char& operator[](unsigned long p) {return string::operator[](p);}
*/
	int asInt() const {return (atoi((const char*)(*this)));}

	KString operator+= (const KString & s) {*this = *this + s; return(*this);}
	KString operator += (const char c) {*this = *this + KString(c); return(*this);}
	KString operator += (const int i) {*this += KString(i); return(*this);}
	KString operator += (const long i) {*this += KString(i); return(*this);}
	KString operator +  (const int i) const {return(*this + KString(i));}
	KString operator +  (const long i) const {return(*this + KString(i));}
	KString operator +  (const char c) const {return(*this + KString(c));}
	bool operator!=(const char* array) const {return compare(array) != 0;}
	bool operator!=(const KString& str) const {return compare((const char *)(str)) != 0;}

//	friend istream& operator>>(istream& aStream, KString& aString);
	friend ostream& operator<<(ostream& out, const KString& data) { out << data.c_str(); return out; }

	friend bool operator !=(const string& data, const char* array) { return data.compare(array) != 0; }
	friend bool operator <=(const string& data, const char* array) { return data.compare(array) <= 0; }
	friend bool operator >=(const string& data, const char* array) { return data.compare(array) >= 0; }
	friend string& operator +=(string& data, const char aChar)
	{
		char buf[2];
		buf[0] = aChar;
		buf[1] = '\0';
		data += buf;
		return (data);
	}
};



#endif     // K_STRING_H
