#include "kstring.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdexcept>
#include <ctype.h>


KString :: KString(int anInt)
{
	char	cpInteger[21];

	sprintf(cpInteger, "%d", anInt);
	this->operator=(cpInteger);
}

KString :: KString(unsigned anUnsigned)
{
	char	cpInteger[21];

	sprintf(cpInteger, "%u", anUnsigned);
	this->operator=(cpInteger);
}


KString :: KString(long aLong)
{
	char	cpLong[21];

	sprintf(cpLong, "%ld", aLong);
	this->operator=(cpLong);
}


KString :: KString(unsigned long anUnsignedLong)
{
	char	cpUnsignedLong[21];

	sprintf(cpUnsignedLong, "%lu", anUnsignedLong);
	this->operator=(cpUnsignedLong);
}


KString :: KString(short aShort)
{
	char	cpShort[21];

	sprintf(cpShort, "%d", (int) aShort);
	this->operator=(cpShort);
}


KString :: KString(unsigned short anUnsignedShort)
{
	char	cpUnsignedShort[21];

	sprintf(cpUnsignedShort, "%u", (unsigned) anUnsignedShort);
	this->operator=(cpUnsignedShort);
}


KString :: KString(double aDouble)
{
	char	cpDouble[21];

	sprintf(cpDouble, "%lf", aDouble);
	this->operator=(cpDouble);
}


KString :: KString(char aChar)
{
	append(1,aChar);
}


KString :: KString(unsigned char anUnsignedChar)
{
	this->operator=((char) anUnsignedChar);
}


KString :: KString(signed char aSignedChar)
{
	this->operator=((char) aSignedChar);
}


KString :: KString(const signed char* pSignedChar)
{
	this->operator=((char*) pSignedChar);
}


KString :: KString(const char* pSignedChar, int len)
{
	append(pSignedChar, len);
}

KString& KString :: strip()
{
	int p1 = find_first_not_of(' ');
	int p2 = find_last_not_of(' ');

	if (p1 == (int) npos || p2 == (int) npos)
	{
		*this = "";
	}
	else
	{
		*this = substr(p1, p2-p1+1);
	}
	return(*this);
}


KString& KString :: translate(const KString& strToChange,
                              const KString& strNew)
{ 
	KString result(*this);
	int p;

	p = result.find(strToChange);

	while(p != (int) npos)
	{
		result = result.substr(0, p) + strNew + result.substr(p + strToChange.length());

		p = result.find(strToChange, p + strNew.length());
	}

	*this = result;
	return *this;
}

KString KString :: word(unsigned startWord, char pad)
{
	return(words(startWord, 1, pad));
}

KString KString :: words(unsigned startWord,
                         unsigned endWord,
                         char pad)
{
	int p;
	int p2;
	int i;

	if (startWord < 1 || endWord < 1)
	{
		return("");
	}

	p = 0;
	if (p == ' ')
	{
		p = find_first_not_of(pad);
	}
		
	if (p == (int) npos)
		return("");

	for(i = 2; i <= (int) startWord; i++)
	{
		p = find(pad,p);
		if (p == (int) npos)
			return("");

		if (pad == ' ')
		{
			p = find_first_not_of(' ',p);
			if (p == (int) npos)
				return("");
		}
		else
		{
			p++;
			if (p > (int) length())
				return("");
		}
	}

	p2 = p;
	p2 = find(pad,p2);
	if (p2 == (int) npos)
		return(substr(p));

	for(i = 2; endWord == npos || i <= (int) endWord; i++)
	{
		p2 = find_first_not_of(pad,p2);
		if (p2 == (int) npos)
			return(KString(substr(p)).strip());
             
		if (pad == ' ')
		{
			p2 = find(' ',p2);
			if (p2 == (int) npos)
				return(KString(substr(p)).strip());
		}
		else
		{
			p2++;
			if (p2 > (int) length())
				return(KString(substr(p)).strip());
		}

	}

	return(KString(substr(p, p2-p)));

}

int KString :: numWords(char pad) const
{
	int p;
	int anzahl(0);

	p = 0;
	if (p == ' ')
	{
		p = find_first_not_of(pad);
	}

	while(p != (int) npos && p <= (int) length())
	{
		anzahl++;
		p = find(pad,p);
		if (p != (int) npos)
		{
			if (pad == ' ')
			{
				p = find_first_not_of(' ',p);
			}
			else
			{
				p++;
			}
		}
	}

	return(anzahl);

}

KString& KString :: upperCase()
{
	int p;

	for (p = 0; p < (int) length(); p ++)
	{
		(*this)[p] = toupper((*this)[p]);
	}

	return(*this);
}

KString& KString :: lowerCase()
{
	int p;

	for (p = 0; p < (int) length(); p++)
	{
		(*this)[p] = tolower((*this)[p]);
	}

	return (*this);
}

KString KString :: mid(int start, int length)
{
	// define local var for the substring
	KString	subString;

	subString = substr(start, length);

	return subString;
}


int KString::occurrencesOf(const KString& str) const
{
	int anzahl(0);
	int p;

	if (str.length() == 0)
	{
		return(0);
	}

	p = find(str);

	while (p != (int) npos)
	{
		anzahl++;
		p = find(str, p + str.length());
	}
	return (anzahl);
}

bool KString::isDigits() const
{
	int p;

	for (p = 0; p < (int) length(); p ++)
	{
		if (!isdigit((*this)[p]))
		{
			return(false);
		}
	}

	return(true);
}

/*
istream& operator>>(istream& aStream, KString& aString)
   {
	if ( aString.length() == 0 )
		aString = aString.leftJustify(128);

	unsigned bytes = 0;
	char c;

	// This following piece of code model after >> on char *
	int peekResult;
	int w = aStream.width(0);

	if (aStream.flags() & ios::skipws)
	{
		if(!aStream.ipfx(0))
		{
			aString = "";
			return aStream;
		}
	}
	else
	{
		if(!aStream.ipfx(w))
		{
			aString = "";
			return aStream;
		}
	}

	if (w > 0)
	{
		for (peekResult = aStream.peek(); !isspace(peekResult) && peekResult != EOF  && --w > 0; peekResult = aStream.peek())
		{
			aStream.get(c);
			if (bytes == aString.length())
				aString += KString().leftJustify(bytes);
			aString[bytes++] = c;
		}
	}
	else
	{
		for (peekResult = aStream.peek(); !isspace(peekResult) && peekResult != EOF; peekResult = aStream.peek())
		{
			aStream.get(c);
			if (bytes == aString.length())
				aString += KString().leftJustify(bytes);
			aString[bytes++] = c;
		}
	}

	// Remove trailing stuff...
	aString.erase(bytes);


	return aStream;
}
*/

bool KString :: isAlphabetic() const
{
	unsigned count;
	char     locArray[1024];

	strcpy(locArray, this->c_str());

	for(count = 0; count < this->length(); count++)
	{
		if (!isalpha(locArray[count]))
		{
			return false;
		}
	}

	return true;
}

KString KString :: upper() const
{
	KString	localString;

	localString = *this;
	localString.upperCase();

	return localString;
}

bool KString :: isEmpty() const
{
	return this->empty();
}


