/***************************************************************************
                                 KSequenceViewer.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "ksequenceviewer.h"
#include "serverwork.h"
#include <kmsgbox.h>
#include "korapic.xpm"

KSequenceViewer::KSequenceViewer(QWidget* parent, const char* name) :
		KDialog( parent, name, TRUE, 1036288 )
{
        // define oracle Message var
	QString	oraMessage;
	
	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	sequenceSelectLabel = new QLabel( this, "sequenceSelectWLabel" );
	sequenceSelectLabel->setGeometry( 15, 10, 120, 15 );
	sequenceSelectLabel->setMinimumSize( 120, 15 );
	sequenceSelectLabel->setMaximumSize( 32767, 15 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		sequenceSelectLabel->setFont( font );
	}
	sequenceSelectLabel->setFocusPolicy( QWidget::NoFocus );
	sequenceSelectLabel->setBackgroundMode( QWidget::PaletteBackground );
	sequenceSelectLabel->setFontPropagation( QWidget::NoChildren );
	sequenceSelectLabel->setPalettePropagation( QWidget::NoChildren );
	sequenceSelectLabel->setFrameStyle( 0 );
	sequenceSelectLabel->setLineWidth( 1 );
	sequenceSelectLabel->setMidLineWidth( 0 );
	sequenceSelectLabel->QFrame::setMargin( 0 );
	sequenceSelectLabel->setText( i18n("Select a Sequence:") );
	sequenceSelectLabel->setAlignment( 289 );
	sequenceSelectLabel->setMargin( -1 );

	sequenceList = new QListBox( this, "sequenceWList" );
	sequenceList->setGeometry( 15, 30, 460, 60 );
	sequenceList->setMinimumSize( 460, 60 );
	sequenceList->setMaximumSize( 32767, 32767 );
	connect( sequenceList, SIGNAL(highlighted(int)), SLOT(sequenceListClickedCB(int)) );
	sequenceList->setFocusPolicy( QWidget::StrongFocus );
	sequenceList->setBackgroundMode( QWidget::PaletteBase );
	sequenceList->setFontPropagation( QWidget::SameFont );
	sequenceList->setPalettePropagation( QWidget::SameFont );
	sequenceList->setFrameStyle( 51 );
	sequenceList->setLineWidth( 2 );
	sequenceList->setMidLineWidth( 0 );
	sequenceList->QFrame::setMargin( 0 );
	sequenceList->setDragSelect( TRUE );
	sequenceList->setAutoScroll( TRUE );
	sequenceList->setScrollBar( FALSE );
	sequenceList->setAutoScrollBar( TRUE );
	sequenceList->setBottomScrollBar( FALSE );
	sequenceList->setAutoBottomScrollBar( TRUE );
	sequenceList->setSmoothScrolling( TRUE );
	sequenceList->setMultiSelection( FALSE );
	sequenceList->setAutoUpdate( TRUE );

	baseFrame = new QFrame( this, "baseWFrame" );
	baseFrame->setGeometry( 15, 105, 460, 75 );
	baseFrame->setMinimumSize( 380, 75 );
	baseFrame->setMaximumSize( 32767, 32767 );
	baseFrame->setFocusPolicy( QWidget::NoFocus );
	baseFrame->setBackgroundMode( QWidget::PaletteBackground );
	baseFrame->setFontPropagation( QWidget::NoChildren );
	baseFrame->setPalettePropagation( QWidget::NoChildren );
	baseFrame->setFrameStyle( 50 );
	baseFrame->setLineWidth( 2 );
	baseFrame->setMidLineWidth( 0 );
	baseFrame->QFrame::setMargin( 0 );

	startLabel = new QLabel( baseFrame, "startWLabel" );
	startLabel->setGeometry( 15, 15, 75, 20 );
	startLabel->setMinimumSize( 75, 20 );
	startLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		startLabel->setFont( font );
	}
	startLabel->setFocusPolicy( QWidget::NoFocus );
	startLabel->setBackgroundMode( QWidget::PaletteBackground );
	startLabel->setFontPropagation( QWidget::NoChildren );
	startLabel->setPalettePropagation( QWidget::NoChildren );
	startLabel->setFrameStyle( 0 );
	startLabel->setLineWidth( 1 );
	startLabel->setMidLineWidth( 0 );
	startLabel->QFrame::setMargin( 0 );
	startLabel->setText( i18n("Start Value:") );
	startLabel->setAlignment( 289 );
	startLabel->setMargin( -1 );

	startValueText = new QLineEdit( baseFrame, "startValueWText" );
	startValueText->setGeometry( 95, 15, 100, 20 );
	startValueText->setMinimumSize( 100, 20 );
	startValueText->setMaximumSize( 100, 20 );
	startValueText->setFocusPolicy( QWidget::StrongFocus );
	startValueText->setBackgroundMode( QWidget::PaletteBase );
	startValueText->setFontPropagation( QWidget::NoChildren );
	startValueText->setPalettePropagation( QWidget::NoChildren );
	startValueText->setText( "" );
	startValueText->setMaxLength( 32767 );
	startValueText->setFrame( QLineEdit::Normal );
	startValueText->setFrame( TRUE );

	endValueLabel = new QLabel( baseFrame, "endValueWLabel" );
	endValueLabel->setGeometry( 280, 15, 60, 20 );
	endValueLabel->setMinimumSize( 60, 20 );
	endValueLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		endValueLabel->setFont( font );
	}
	endValueLabel->setFocusPolicy( QWidget::NoFocus );
	endValueLabel->setBackgroundMode( QWidget::PaletteBackground );
	endValueLabel->setFontPropagation( QWidget::NoChildren );
	endValueLabel->setPalettePropagation( QWidget::NoChildren );
	endValueLabel->setFrameStyle( 0 );
	endValueLabel->setLineWidth( 1 );
	endValueLabel->setMidLineWidth( 0 );
	endValueLabel->QFrame::setMargin( 0 );
	endValueLabel->setText( i18n("End Value:") );
	endValueLabel->setAlignment( 289 );
	endValueLabel->setMargin( -1 );

	endValueText = new QLineEdit( baseFrame, "endValueWText" );
	endValueText->setGeometry( 345, 15, 100, 20 );
	endValueText->setMinimumSize( 100, 20 );
	endValueText->setMaximumSize( 100, 20 );
	endValueText->setFocusPolicy( QWidget::StrongFocus );
	endValueText->setBackgroundMode( QWidget::PaletteBase );
	endValueText->setFontPropagation( QWidget::NoChildren );
	endValueText->setPalettePropagation( QWidget::NoChildren );
	endValueText->setText( "" );
	endValueText->setMaxLength( 32767 );
	endValueText->setFrame( QLineEdit::Normal );
	endValueText->setFrame( TRUE );

	incrementLabel = new QLabel( baseFrame, "incrementWLabel" );
	incrementLabel->setGeometry( 15, 50, 75, 20 );
	incrementLabel->setMinimumSize( 75, 20 );
	incrementLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		incrementLabel->setFont( font );
	}
	incrementLabel->setFocusPolicy( QWidget::NoFocus );
	incrementLabel->setBackgroundMode( QWidget::PaletteBackground );
	incrementLabel->setFontPropagation( QWidget::NoChildren );
	incrementLabel->setPalettePropagation( QWidget::NoChildren );
	incrementLabel->setFrameStyle( 0 );
	incrementLabel->setLineWidth( 1 );
	incrementLabel->setMidLineWidth( 0 );
	incrementLabel->QFrame::setMargin( 0 );
	incrementLabel->setText( i18n("Increment:") );
	incrementLabel->setAlignment( 289 );
	incrementLabel->setMargin( -1 );

	incrementText = new QLineEdit( baseFrame, "incrementWText" );
	incrementText->setGeometry( 95, 50, 100, 20 );
	incrementText->setMinimumSize( 100, 20 );
	incrementText->setMaximumSize( 100, 20 );
	incrementText->setFocusPolicy( QWidget::StrongFocus );
	incrementText->setBackgroundMode( QWidget::PaletteBase );
	incrementText->setFontPropagation( QWidget::NoChildren );
	incrementText->setPalettePropagation( QWidget::NoChildren );
	incrementText->setText( "" );
	incrementText->setMaxLength( 32767 );
	incrementText->setFrame( QLineEdit::Normal );
	incrementText->setFrame( TRUE );

	cycleLabel = new QLabel( baseFrame, "cycleWLabel" );
	cycleLabel->setGeometry( 290, 50, 50, 20 );
	cycleLabel->setMinimumSize( 50, 20 );
	cycleLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		cycleLabel->setFont( font );
	}
	cycleLabel->setFocusPolicy( QWidget::NoFocus );
	cycleLabel->setBackgroundMode( QWidget::PaletteBackground );
	cycleLabel->setFontPropagation( QWidget::NoChildren );
	cycleLabel->setPalettePropagation( QWidget::NoChildren );
	cycleLabel->setFrameStyle( 0 );
	cycleLabel->setLineWidth( 1 );
	cycleLabel->setMidLineWidth( 0 );
	cycleLabel->QFrame::setMargin( 0 );
	cycleLabel->setText( i18n("Cycling:") );
	cycleLabel->setAlignment( 289 );
	cycleLabel->setMargin( -1 );

	cycleText = new QLineEdit( baseFrame, "cycleWText" );
	cycleText->setGeometry( 345, 50, 100, 20 );
	cycleText->setMinimumSize( 100, 20 );
	cycleText->setMaximumSize( 32767, 20 );
	cycleText->setFocusPolicy( QWidget::StrongFocus );
	cycleText->setBackgroundMode( QWidget::PaletteBase );
	cycleText->setFontPropagation( QWidget::NoChildren );
	cycleText->setPalettePropagation( QWidget::NoChildren );
	cycleText->setText( "" );
	cycleText->setMaxLength( 32767 );
	cycleText->setFrame( QLineEdit::Normal );
	cycleText->setFrame( TRUE );

	closeButton = new QPushButton( this, "closeWButton" );
	closeButton->setGeometry( 375, 185, 100, 30 );
	closeButton->setMinimumSize( 100, 30 );
	closeButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		closeButton->setFont( font );
	}
	connect( closeButton, SIGNAL(clicked()), SLOT(closeButtonClickedCB()) );
	closeButton->setFocusPolicy( QWidget::TabFocus );
	closeButton->setBackgroundMode( QWidget::PaletteBackground );
	closeButton->setFontPropagation( QWidget::NoChildren );
	closeButton->setPalettePropagation( QWidget::NoChildren );
	closeButton->setText( i18n("Close") );
	closeButton->setAutoRepeat( FALSE );
	closeButton->setAutoResize( FALSE );
	closeButton->setToggleButton( FALSE );
	closeButton->setDefault( FALSE );
	closeButton->setAutoDefault( TRUE );
	closeButton->setIsMenuButton( FALSE );

	QBoxLayout* layout1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "top" );
	layout1->addStrut( 0 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "listbase" );
	layout1->addLayout( layout1_2, 1 );
	layout1_2->addStrut( 0 );
	layout1_2->addSpacing( 10 );
	layout1_2->addWidget( sequenceSelectLabel, 1, 36 );
	layout1_2->addStretch( 10 );
	QBoxLayout* layout1_3 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "listselect" );
	layout1->addLayout( layout1_3, 10 );
	layout1_3->addStrut( 0 );
	layout1_3->addSpacing( 10 );
	layout1_3->addWidget( sequenceList, 10, 36 );
	layout1_3->addSpacing( 10 );
	layout1->addSpacing( 10 );
	QBoxLayout* layout1_5 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "detailarea" );
	layout1->addLayout( layout1_5, 1 );
	layout1_5->addStrut( 0 );
	layout1_5->addSpacing( 10 );
	layout1_5->addWidget( baseFrame, 1, 36 );
	QBoxLayout* layout1_5_2 = new QBoxLayout( baseFrame, QBoxLayout::TopToBottom, 5, 5, "framebase" );
	layout1_5_2->addStrut( 0 );
	layout1_5_2->addSpacing( 10 );
	QBoxLayout* layout1_5_2_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "startend" );
	layout1_5_2->addLayout( layout1_5_2_2, 1 );
	layout1_5_2_2->addStrut( 0 );
	layout1_5_2_2->addSpacing( 10 );
	layout1_5_2_2->addWidget( startLabel, 1, 36 );
	layout1_5_2_2->addWidget( startValueText, 1, 36 );
	layout1_5_2_2->addStretch( 10 );
	layout1_5_2_2->addWidget( endValueLabel, 1, 36 );
	layout1_5_2_2->addWidget( endValueText, 1, 36 );
	layout1_5_2_2->addSpacing( 10 );
	layout1_5_2->addSpacing( 10 );
	QBoxLayout* layout1_5_2_4 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "inccycle" );
	layout1_5_2->addLayout( layout1_5_2_4, 1 );
	layout1_5_2_4->addStrut( 0 );
	layout1_5_2_4->addSpacing( 10 );
	layout1_5_2_4->addWidget( incrementLabel, 1, 36 );
	layout1_5_2_4->addWidget( incrementText, 1, 36 );
	layout1_5_2_4->addStretch( 10 );
	layout1_5_2_4->addWidget( cycleLabel, 1, 36 );
	layout1_5_2_4->addWidget( cycleText, 1, 36 );
	layout1_5_2_4->addSpacing( 10 );
	layout1_5->addSpacing( 10 );
	QBoxLayout* layout1_6 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "buttonarea" );
	layout1->addLayout( layout1_6, 1 );
	layout1_6->addStrut( 0 );
	layout1_6->addStretch( 10 );
	layout1_6->addWidget( closeButton, 1, 36 );
	layout1_6->addSpacing( 10 );
	layout1->addSpacing( 20 );
	resize( 490,240 );
	setMinimumSize( 510, 380 );
	setMaximumSize( 32767, 32767 );

	setCaption( i18n("View Sequences") );

	KApplication::setOverrideCursor(waitCursor);
	// fill the listbox of the sequences and get the additional data
	if (ServerWork::fillSequenceList(sequenceList, oraMessage))
	{
		// an error occured
		KApplication::restoreOverrideCursor();
		KMsgBox::message(this, i18n("Oracle Error"), oraMessage, KMsgBox::STOP);
	}

	KApplication::restoreOverrideCursor();
}


KSequenceViewer::~KSequenceViewer()
{
}

void KSequenceViewer::sequenceListClickedCB(int item)
{
	QString	maxValue;
	QString	minValue;
	long	increment;
	QString	cycleFlag;
	QString	incString;
	char	formatString[10240];

	if (!ServerWork::getSequenceData(item, maxValue, minValue, &increment, cycleFlag))
	{
		// unable to get data for that item
		KMsgBox::message(this, i18n("Sequence Error"), i18n("Unable to find data for the specified sequence."), KMsgBox::STOP);
		return;
	}

	// ok, we have the data. Fill them into the fields
	startValueText->setText(minValue);
	endValueText->setText(maxValue);
	sprintf(formatString, "%ld", increment);
	incString = formatString;
	incrementText->setText(incString);
	cycleText->setText(cycleFlag);
}

void KSequenceViewer::closeButtonClickedCB()
{
	this->close();
}
