/***************************************************************************
                                 KPackageEditor.cpp
                             -------------------
    begin                : 09.08.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "kpackageeditor.h"
#include <kmsgbox.h>
#include "korapic.xpm"
#include "serverwork.h"


KPackageEditor::KPackageEditor
(
	QWidget* parent,
	const char* name
)
	:
	KDialog( parent, name, TRUE, 1036288 )
{
	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	packageLabel = new QLabel( this, "packageWLabel" );
	packageLabel->setGeometry( 10, 17, 430, 30 );
	packageLabel->setMinimumSize( 430, 30 );
	packageLabel->setMaximumSize( 32767, 30 );
	{
		QFont font( "helvetica", 18, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		packageLabel->setFont( font );
	}
	packageLabel->setFocusPolicy( QWidget::NoFocus );
	packageLabel->setBackgroundMode( QWidget::PaletteBackground );
	packageLabel->setFontPropagation( QWidget::NoChildren );
	packageLabel->setPalettePropagation( QWidget::NoChildren );
	packageLabel->setFrameStyle( 0 );
	packageLabel->setLineWidth( 1 );
	packageLabel->setMidLineWidth( 0 );
	packageLabel->QFrame::setMargin( 0 );
	packageLabel->setText( "<PackageName>" );
	packageLabel->setAlignment( 292 );
	packageLabel->setMargin( -1 );

	packageMultiText = new QMultiLineEdit( this, "packageWMultiText" );
	packageMultiText->setGeometry( 10, 64, 460, 314 );
	packageMultiText->setMinimumSize( 440, 300 );
	packageMultiText->setMaximumSize( 32767, 32767 );
	packageMultiText->setFocusPolicy( QWidget::StrongFocus );
	packageMultiText->setBackgroundMode( QWidget::PaletteBase );
	packageMultiText->setFontPropagation( QWidget::SameFont );
	packageMultiText->setPalettePropagation( QWidget::SameFont );
	packageMultiText->setFrameStyle( 51 );
	packageMultiText->setLineWidth( 2 );
	packageMultiText->setMidLineWidth( 0 );
	packageMultiText->QFrame::setMargin( 0 );
//	packageMultiText->insertLine( "" );
	packageMultiText->setReadOnly( FALSE );
	packageMultiText->setOverwriteMode( FALSE );
	packageMultiText->setAutoUpdate( TRUE );

	outputLabel = new QLabel( this, "outputWLabel" );
	outputLabel->setGeometry( 10, 395, 60, 20 );
	outputLabel->setMinimumSize( 60, 20 );
	outputLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		outputLabel->setFont( font );
	}
	outputLabel->setFocusPolicy( QWidget::NoFocus );
	outputLabel->setBackgroundMode( QWidget::PaletteBackground );
	outputLabel->setFontPropagation( QWidget::NoChildren );
	outputLabel->setPalettePropagation( QWidget::NoChildren );
	outputLabel->setFrameStyle( 0 );
	outputLabel->setLineWidth( 1 );
	outputLabel->setMidLineWidth( 0 );
	outputLabel->QFrame::setMargin( 0 );
	outputLabel->setText( i18n("Output:") );
	outputLabel->setAlignment( 289 );
	outputLabel->setMargin( -1 );

	outputMultiText = new QMultiLineEdit( this, "outputWMultiText" );
	outputMultiText->setGeometry( 10, 427, 460, 124 );
	outputMultiText->setMinimumSize( 440, 110 );
	outputMultiText->setMaximumSize( 32767, 32767 );
	outputMultiText->setFocusPolicy( QWidget::StrongFocus );
	outputMultiText->setBackgroundMode( QWidget::PaletteBase );
	outputMultiText->setFontPropagation( QWidget::SameFont );
	outputMultiText->setPalettePropagation( QWidget::SameFont );
	outputMultiText->setFrameStyle( 51 );
	outputMultiText->setLineWidth( 2 );
	outputMultiText->setMidLineWidth( 0 );
	outputMultiText->QFrame::setMargin( 0 );
//	outputMultiText->insertLine( "" );
	outputMultiText->setReadOnly( TRUE );
	outputMultiText->setOverwriteMode( FALSE );
	outputMultiText->setAutoUpdate( TRUE );

	compileButton = new QPushButton( this, "compileWButton" );
	compileButton->setGeometry( 10, 573, 100, 30 );
	compileButton->setMinimumSize( 100, 30 );
	compileButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		compileButton->setFont( font );
	}
	connect( compileButton, SIGNAL(clicked()), SLOT(compileButtonClickedCB()) );
	compileButton->setFocusPolicy( QWidget::TabFocus );
	compileButton->setBackgroundMode( QWidget::PaletteBackground );
	compileButton->setFontPropagation( QWidget::NoChildren );
	compileButton->setPalettePropagation( QWidget::NoChildren );
	compileButton->setText( i18n("Compile") );
	compileButton->setAutoRepeat( FALSE );
	compileButton->setAutoResize( FALSE );
	compileButton->setToggleButton( FALSE );
	compileButton->setDefault( FALSE );
	compileButton->setAutoDefault( TRUE );
	compileButton->setIsMenuButton( FALSE );

	returnButton = new QPushButton( this, "returnWButton" );
	returnButton->setGeometry( 370, 573, 100, 30 );
	returnButton->setMinimumSize( 100, 30 );
	returnButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		returnButton->setFont( font );
	}
	connect( returnButton, SIGNAL(clicked()), SLOT(returnButtonClickedCB()) );
	returnButton->setFocusPolicy( QWidget::TabFocus );
	returnButton->setBackgroundMode( QWidget::PaletteBackground );
	returnButton->setFontPropagation( QWidget::NoChildren );
	returnButton->setPalettePropagation( QWidget::NoChildren );
	returnButton->setText( i18n("Return") );
	returnButton->setAutoRepeat( FALSE );
	returnButton->setAutoResize( FALSE );
	returnButton->setToggleButton( FALSE );
	returnButton->setDefault( FALSE );
	returnButton->setAutoDefault( FALSE );
	returnButton->setIsMenuButton( FALSE );

	QBoxLayout* layout1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "top" );
	layout1->addStrut( 0 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "title" );
	layout1->addLayout( layout1_2, 1 );
	layout1_2->addStrut( 0 );
	layout1_2->addSpacing( 5 );
	layout1_2->addWidget( packageLabel, 1, 36 );
	layout1_2->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_4 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "input" );
	layout1->addLayout( layout1_4, 10 );
	layout1_4->addStrut( 0 );
	layout1_4->addSpacing( 5 );
	layout1_4->addWidget( packageMultiText, 1, 36 );
	layout1_4->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_6 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "outputHead" );
	layout1->addLayout( layout1_6, 1 );
	layout1_6->addStrut( 0 );
	layout1_6->addSpacing( 5 );
	layout1_6->addWidget( outputLabel, 1, 36 );
	layout1_6->addStretch( 10 );
	QBoxLayout* layout1_7 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "output" );
	layout1->addLayout( layout1_7, 1 );
	layout1_7->addStrut( 0 );
	layout1_7->addSpacing( 5 );
	layout1_7->addWidget( outputMultiText, 1, 36 );
	layout1_7->addSpacing( 5 );
	layout1->addSpacing( 10 );
	QBoxLayout* layout1_9 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "buttons" );
	layout1->addLayout( layout1_9, 1 );
	layout1_9->addStrut( 0 );
	layout1_9->addSpacing( 5 );
	layout1_9->addWidget( compileButton, 1, 36 );
	layout1_9->addStretch( 10 );
	layout1_9->addWidget( returnButton, 1, 36 );
	layout1_9->addSpacing( 5 );
	layout1->addSpacing( 5 );
	resize( 480,620 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );

	setCaption( i18n("Package Editor") );

}


KPackageEditor::~KPackageEditor()
{
}
void KPackageEditor::compileButtonClickedCB()
{
	QString	oraMessage;
	QString	sqlResult;
	int	processedRows;

	// clear the output field
	outputMultiText->clear();

	// set the wait cursor
	KApplication::setOverrideCursor(waitCursor);

	// execute the package create
	if (ServerWork::executeSql(packageMultiText->text(), oraMessage, &processedRows, sqlResult, TRUE))
	{
		// an error occured.
		// write the sql result
		outputMultiText->insertLine(sqlResult);
		// reset the override cursor
		KApplication::restoreOverrideCursor();
		// write the Oracle Error
		KMsgBox::message(this, i18n("Oracle Error"), oraMessage, KMsgBox::STOP);
	}
	else
	{
		// write the sql result
		outputMultiText->insertLine(sqlResult);
		// write the error messages to output field
		outputMultiText->insertLine(ServerWork::getPlSqlCompileError(packageIndex, packageType));
		// reset the override cursor
		KApplication::restoreOverrideCursor();
	}
}

void KPackageEditor::returnButtonClickedCB()
{
	this->close();
}

void KPackageEditor::setTitle(const QString& title)
{
	packageLabel->setText(title);
}

void KPackageEditor::setText(const QString& text)
{
	packageMultiText->insertLine(text);
}
