#include "tabledescr.h"

#ifndef rcsid
static const char rcsid[]="$Id: tabledescr.cpp,v 2.7 1999/08/07 19:33:12 ral Exp $";
const char*tabledescr_rcs(){return rcsid;}
#endif

CKeyDescriptor::CKeyDescriptor(const CKeyDescriptor&old) 
{
    name = old.name;
    ColumnsList = old.ColumnsList;
    type = old.type;
    compound = old.is_compound();
}

CKeyDescriptor&CKeyDescriptor::operator=(const CKeyDescriptor&old)
{
    name = old.name;
    ColumnsList = old.ColumnsList;
    type = old.type;
    compound = old.is_compound();
    return *this;
}

int CKeyDescriptor::add_column_name(const char*column)
{
    if (!column || !strlen(column))
	return 0;
    stringIlist::iterator iter;
    iter = ColumnsList.find(column);
    if (iter != 0) {
	return -1;
    }
    ColumnsList.push_back(std::string(column));
    return 1;
}

void CKeyDescriptor::remove_column_name(const char*column)
{
    if (!column || !strlen(column) )
	return;
    stringIlist::iterator iter;
    iter = ColumnsList.find(column);
    if (iter != 0)
	ColumnsList.erase(iter);
}

bool CKeyDescriptor::contains_column_name(const char*column)
{
    if (!column || !strlen(column))
	return false;
    return (ColumnsList.find(column) != 0);
}

CColumnDescriptor::CColumnDescriptor()
{
    name = "";
    Def = "";
    table = "";
    
    FieldType = 0;
    MaxLength = 0;
    MaxDecimals = 0;
    
    AutoIncrement = false;
    KeyField = false;
    Binary = false;
    TimeStamp = false;
    ZeroFill = false;
    NotNull = false;
    Blob = false;
    PartOfMultiple = false;
    Numeric = false;
    UniqueValue = false;
}

void CColumnDescriptor::copy_old(const CColumnDescriptor*old)
{
    name = old->name;
    Def = old->Def;
    table = old->table;
    
    FieldType = old->FieldType;
    MaxLength = old->MaxLength;
    MaxDecimals = old->MaxDecimals;
    
    AutoIncrement = old->AutoIncrement;
    KeyField = old->KeyField;
    Binary = old->Binary;
    TimeStamp = old->TimeStamp;
    ZeroFill = old->ZeroFill;
    NotNull = old->NotNull;
    Blob = old->Blob;
    PartOfMultiple = old->PartOfMultiple;
    Numeric = old->Numeric;
    UniqueValue = old->UniqueValue;
    Enums = old->Enums;
}

CColumnDescriptor::CColumnDescriptor(const CColumnDescriptor&old)
{
    copy_old(&old);
}

CColumnDescriptor& CColumnDescriptor::operator=(const CColumnDescriptor&old)
{
    copy_old(&old);
    return *this;
}

void CColumnDescriptor::remove_enum(const std::string&what)
{
    stringIlist::iterator iter;
    iter = Enums.find(what);
    if (iter) {
	Enums.erase(iter);
    }
}
