#include <kapp.h>
#include "MainWindow.h"
#include "Login.h"
#include "CreateTable.h"
#include "TextInput.h"
#include "TableView.h"
#include "StatusView.h"
#include "granttable.h"
#include "mysqlw.h"
#include "ThreadView.h"
#include "globals.h"
#include "deltabledlg.h"
#include <qmsgbox.h>

#ifndef rcsid
static const char rcsid[]="$Id: MainWindow.cpp,v 2.2 1999/07/04 22:30:42 ral Exp $";
const char*mainwindow_rcs(){return rcsid;}
#endif

#define Inherited CMainWindowData

CMainWindow::CMainWindow( QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    accessButton->setEnabled(FALSE);
    ThreadButton->setEnabled(FALSE);
    CreateDBButton->setEnabled(FALSE);
    CreateTableButton->setEnabled(FALSE);
    AlterTableButton->setEnabled(FALSE);
    StatusButton->setEnabled(FALSE);
    browseTablesButton->setEnabled(FALSE);
    TableView = 0;
    StatusView = 0;
    ThreadView = 0;
    sql_server = 0;
    Grants = 0;
}


CMainWindow::~CMainWindow()
{
    if (sql_server)
	delete sql_server;
}

void CMainWindow::connectSql()
{
    CLogin login;
    QString host;
    QString User;
    QString pass;
    QString port;
    if (login.exec()) {
	if (!sql_server)
	    sql_server = new CMySql;
	sql_server->set_message_call_back(&append_status_text);
	host = login.get_host();
	User = login.get_user();
	pass = login.get_pass();
	port = login.get_port();
	if (StatusView) {
	    delete StatusView;StatusView = 0L;
	}
	if (TableView) {
	    delete TableView;TableView = 0L;
	}
	if (ThreadView) {
	    delete ThreadView;ThreadView = 0L;
	}
	if (Grants) {
	    delete Grants;Grants = 0;
	}
	sql_server->sql_connect(host,User,pass,port);
	if (sql_server->success_connect()) {
	    accessButton->setEnabled(TRUE);
	    ThreadButton->setEnabled(TRUE);
	    CreateDBButton->setEnabled(TRUE);
	    CreateTableButton->setEnabled(TRUE);
	    AlterTableButton->setEnabled(TRUE);
	    StatusButton->setEnabled(TRUE);
	    browseTablesButton->setEnabled(TRUE);
	    emit connected();
	}
	else {
	    QString msg = i18n("Could not connect to SQL-Server!");
	    msg+="\n";
	    msg+=i18n("Please check username and password");
	    QMessageBox::critical(this,
				  i18n("Error connect"),
				  msg);
	    accessButton->setEnabled(FALSE);
	    ThreadButton->setEnabled(FALSE);
	    CreateDBButton->setEnabled(FALSE);
	    CreateTableButton->setEnabled(FALSE);
	    AlterTableButton->setEnabled(FALSE);
	    StatusButton->setEnabled(FALSE);
	    browseTablesButton->setEnabled(FALSE);
	    emit disconnected();

	}
	append_message(sql_server->get_info());
    }

}

void CMainWindow::disconnectSql()
{
    if (!sql_server)
	return;
    sql_server->sql_disconnect();
    accessButton->setEnabled(FALSE);
    ThreadButton->setEnabled(FALSE);
    CreateDBButton->setEnabled(FALSE);
    CreateTableButton->setEnabled(FALSE);
    AlterTableButton->setEnabled(FALSE);
    StatusButton->setEnabled(FALSE);
    browseTablesButton->setEnabled(FALSE);
    append_message("Disconnected");
    if (StatusView) {
	delete StatusView;StatusView = 0L;
    }
    if (TableView) {
	delete TableView;TableView = 0L;
    }
    if (ThreadView) {
	delete ThreadView;ThreadView = 0L;
    }
    if (Grants) {
	delete Grants; Grants = 0;
    }
    emit disconnected();
}
    
void CMainWindow::browseTables()
{
    if (!TableView)
	TableView = new CTableView(0,"TableView");
    if (!TableView->isVisible())
	TableView->show();
}

void CMainWindow::append_message(const char*text)
{
    if (!text)
	return;
    OutputArea->append(text);
    OutputArea->setCursorPosition(OutputArea->numLines(),0);
}

void CMainWindow::createTable()
{
    CCreateTable tablec(this);
    tablec.exec();
}

void CMainWindow::createDB()
{
    int i;
    QString s;
    CTextInput input;
    i = input.exec();
    if (!i)
	return;
    s = input.get_text();
    if (s.isEmpty())
	return;
    i = sql_server->create_db(input.get_text());
}

void CMainWindow::dispStatus()
{
    if (!StatusView)
	StatusView = new CStatusView(0,"StatusView");
    if (!StatusView->isVisible())
	StatusView->show();
}

void CMainWindow::view_threads()
{
    if (!ThreadView)
	ThreadView = new CThreadView;
    if (!ThreadView->isVisible())
	ThreadView->show();
}

void CMainWindow::clearOutput()
{
    OutputArea->clear();
}

void CMainWindow::accessControl()
{
    if (!Grants)
	Grants = new CGrantTable;
    if (!Grants->isVisible())
	Grants->show();
}

void CMainWindow::reload_grants()
{
    if (sql_server)
	sql_server->refresh_grants();
}

void CMainWindow::flush_cache()
{
    if (sql_server)
	sql_server->refresh_cache();
}

void CMainWindow::close_tables()
{
    if (sql_server)
	sql_server->refresh_tables();
}

void CMainWindow::new_log()
{
    if (sql_server)
	sql_server->refresh_log();
}

void CMainWindow::shutdown()
{
    int i;
    if (sql_server) {
	i = sql_server->shutdown();
	if (i < 0)
	    return;
	disconnectSql();
    }
}

void CMainWindow::drop_table()
{
    int i = 0;
    CDeleteTableDlg drop_table_dlg(this,"Delete Table");
    i = drop_table_dlg.exec();
}

void CMainWindow::drop_db()
{
}
