/***************************************************************************
                          csearchanalysis.h  -  description                              
                             -------------------                                         
    begin                : Thu Sep 2 1999                                           
    copyright            : (C) 1999 by Joachim Ansorg
    email                : Jockel123@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CSEARCHANALYSIS_H
#define CSEARCHANALYSIS_H

#include <qwidget.h>
#include <qstrlist.h>
#include <qscrollview.h>

#include "cchartwidget.h"

/**
	*This class is an implmentation of the searchanalysis.
	*It should analyse the searchresults and paint a chart for it.
	*It makes a chart for the number of words in every book.
  *@author Joachim Ansorg
  */
class CSearchAnalysis : public	QScrollView
{
   Q_OBJECT

public:
	CSearchAnalysis(QWidget *parent=0, const char *name=0, QStrList *resultList=0);
	~CSearchAnalysis();

protected:
  /** Implementation of the resize event.
		* Change the size of the chartWIdget to the viewed
		* size of this widget.
		*/
  virtual void resizeEvent(QResizeEvent *event);

  /** Starts analysis of the list
		* This function has to be optimized to make the graphical analysis more fast.
		*/
  virtual void analyse();

  /** Returns the count of the given bookname in the list.
  	*
  	* @param	bookname	We want to have the count for this bookname.
  	*/
  virtual int getCount( QString bookname );
	
	/**	Returns the bookname for the given booknumber.
		*/
	QString CSearchAnalysis::getBookName( int number );
	
	/** A copy of the list given to the constructor.
		*/
  QStrList	*list;

  int lastListPos;
 	int maxCount;
	
	/** This is thw widgets which we use to paint the bars.
		*/
	CChartWidget	*chartWidget; 	
};

#endif