/***************************************************************************
                          bmgroupproperties.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jul 27 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include "bmgroupproperties.h"

BMGroupProperties::BMGroupProperties(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	connect (okButton, SIGNAL(clicked()), SLOT(accept()));
	connect (cancelButton, SIGNAL(clicked()), SLOT(reject()));
	groupNameEdit->setFocusPolicy(QWidget::StrongFocus);
}

BMGroupProperties::~BMGroupProperties(){
}

void BMGroupProperties::slotSetGroupName(const QString &n)
{
	groupNameEdit->setText(n.data());
	groupNameEdit->selectAll();
	groupNameEdit->setCursorPosition(n.length());
	groupNameEdit->setFocus();
}

QString BMGroupProperties::groupName()
{
	QString ret =	groupNameEdit->text();
	return ret;
}






