/**********************************************************************

	--- Qt Architect generated file ---

	File: SearchTextDialog.cpp
	Last generated: Fri Jun 18 13:33:14 1999

 *********************************************************************/

#include "SearchTextDialog.h"
//QT includes
#include <qcombobox.h>

#define Inherited SearchTextDialogData

SearchTextDialog::SearchTextDialog(QWidget* parent,const char* name):
									Inherited( parent, name )
{
	connect(searchPhraseEntry, SIGNAL(returnPressed()),
					this, SLOT(slotSearchStart()));
	connect(searchButton, SIGNAL(clicked()),
					this, SLOT(slotSearchStart()));

	connect(searchProperties,SIGNAL(clicked(int)), 	
					this, SLOT(slotSearchProperties(int)));

	setI18n();
}


SearchTextDialog::~SearchTextDialog()
{
}

void SearchTextDialog::slotSetCurrentKeyText(const QString& text)
{
	currentTextLabel->setText(text.data());
}

void SearchTextDialog::slotSearchProperties(int c)
{
	switch (c)
	{
		// Multi Word
		case 0: searchType  = BibleTimeApp::MultiWord;	break;
		// Phrase Search
		case 1: searchType  = BibleTimeApp::ExactPhrase;	break;
		// regular expression
		case 2: searchType  = BibleTimeApp::RegEx;	break;
		// default search property
		default: searchType = BibleTimeApp::ExactPhrase;
	}
}

void SearchTextDialog::slotSearchStart()
{
		//show some parts of the dialog disabled
	searchPhraseEntry->setEnabled(false);
	searchButton->setEnabled(false);
	caseSensitiveFlag->setEnabled(false);
	searchProperties->setEnabled(false);
	multiWord_Button->setEnabled(false);
	exactPhrase_Button->setEnabled(false);
	regExp_Button->setEnabled(false);

	//now emit the signal
	emit sigSearchButtonClicked(searchType,caseSensitiveFlag->isChecked(),searchPhraseEntry->text());
}

void SearchTextDialog::slotSearchEnd()
{
	//now enable the parts we disabled in slotSearchStart()
	searchPhraseEntry->setEnabled(true);
	searchButton->setEnabled(true);
	caseSensitiveFlag->setEnabled(true);
	searchProperties->setEnabled(true);
	multiWord_Button->setEnabled(true);
	exactPhrase_Button->setEnabled(true);
	regExp_Button->setEnabled(true);
}

/** Updates the client widgets to the full width */
void SearchTextDialog::resizeEvent(QResizeEvent* event)
{
	if ( this->width()!=0 )
	{
		searchPhraseEntry->setGeometry(5,5, this->width()-10, 30);
		
		searchProperties->setGeometry(5,40, (this->width()-searchButton->width()-15), 70);
		multiWord_Button->setGeometry(10,45, this->width()-searchButton->width()-25, 20);
		exactPhrase_Button->setGeometry(10,65, this->width()-searchButton->width()-25, 20);
		regExp_Button->setGeometry(10,85, this->width()-searchButton->width()-25, 20);
		
		caseSensitiveFlag->setGeometry(this->width()-caseSensitiveFlag->width()-5,40, 70,40);
		searchButton->setGeometry(this->width()-75,80, 70,30);
				
		currentTextLabel->setGeometry(5,this->height()-35, this->width()-10, 30);
	};
}

/** Set internationalisation */
void SearchTextDialog::setI18n()
{
	searchButton->setText(i18n("Search"));
	caseSensitiveFlag->setText(i18n("case\nsensitive"));

	multiWord_Button->setText( i18n("Multi Word") );
	exactPhrase_Button->setText( i18n("Exact Phrase") );
	regExp_Button->setText( i18n("Reg. Expression") );		
}

