/*
    File: ledtoolbar.h
    Version: 0.2.4
    Date: 31-DEC-1998
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    The LedToolBar shows the line activities (RX,TX,RTS,CTS etc.)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#ifndef LEDTOOLBAR_H
#define LEDTOOLBAR_H



#include <ktoolbar.h>
#include "smif.h"
#include "led.h"


// number of LEDs

#define NUM_LEDS 8



// define led positions

#define LED_TX  0
#define LED_RX  1
#define LED_RTS 2
#define LED_CTS 3
#define LED_DTR 4
#define LED_DSR 5
#define LED_DCD 6
#define LED_RI  7



// class definition

class LedToolBar : public KToolBar {

public:

  // constructor
  LedToolBar(smif* smon,QWidget* parent=0);

private:

  // smif to refer to
  smif* serialmon;

  // leds
  led* statLed[NUM_LEDS];

  // labels for leds
  QLabel* ledLabel[NUM_LEDS];

};



#endif
