/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [te_demo.cpp]            Testbed for TE shell                              */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* copyright (c) 1997 by Lars Doelle <lars.doelle@on-line.de>                 */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is copyleft under the GNU General Public Licence.        */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <kfm.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <kcolordlg.h>

#include "Shell.h"
#include "TEWidget.h"
#include "vt102emu.h"


class TEDemo : public KTopLevelWidget // QWidget
{ Q_OBJECT
public:
  TEDemo(const char *name=0);
  ~TEDemo();
private:
  Shell*         sh;
  TEWidget*      te;
  Emulation*     em;
//
  QPopupMenu* m_options;


private slots:
  void configureRequest(TEWidget*,int,int);

  void select_background_color();
  void select_foreground_color();
  void color_menu_activated(int item);
};

TEDemo::TEDemo(const char *name=0) : KTopLevelWidget(name)
{
  // create terminal emulation framework ////////////////////////////////////

  sh = new Shell();
  te = new TEWidget(this);
  em = new VT102Emulation(te);
  sh->setSize(te->Lines(),te->Columns()); // not absolutely nessesary
  QObject::connect( sh,SIGNAL(block_in(char*,int)), 
                    em,SLOT(onRcvBlock(char*,int)) );
  QObject::connect( em,SIGNAL(ImageSizeChanged(int,int)),
                    sh,SLOT(setSize(int,int)));
  QObject::connect( em,SIGNAL(sndBlock(char*,int)), 
                    sh,SLOT(send_bytes(char*,int)) );
  QObject::connect( sh,SIGNAL(done()), 
                    kapp,SLOT(quit()) );
  QObject::connect( te,SIGNAL(configureRequest(TEWidget*,int,int)),
                    this,SLOT(configureRequest(TEWidget*,int,int)) );
  sh->run();

  // options (taken from kvt) //////////////////////////////////////

  QPopupMenu* m_size = new QPopupMenu;
//CHECK_PTR( m_size );
  m_size->insertItem( klocale->translate("&Normal"));
  m_size->insertItem( klocale->translate("&Tiny"));
  m_size->insertItem( klocale->translate("&Small"));
  m_size->insertItem( klocale->translate("&Medium"));
  m_size->insertItem( klocale->translate("&Large"));
  m_size->insertItem( klocale->translate("&Huge"));
//connect(m_size, SIGNAL(activated(int)), SLOT(size_menu_activated(int)));

//m_dimen = new QPopupMenu;
//CHECK_PTR( m_dimen );
//for (int i=0; kvt_dimens[i].text; i++) {
//  m_dimen->insertItem(kvt_dimens[i].text);
//}
//connect(m_dimen, SIGNAL(activated(int)), SLOT(dimen_menu_activated(int)));
  
  QPopupMenu* m_color = new QPopupMenu;
//CHECK_PTR( m_color );
  m_color->insertItem( klocale->translate("&black/white"));
  m_color->insertItem( klocale->translate("&white/black"));
  m_color->insertItem( klocale->translate("&green/black"));
  m_color->insertItem( klocale->translate("black/light&yellow"));

  QPopupMenu* colors = new QPopupMenu;
//CHECK_PTR( colors );
  colors->insertItem(klocale->translate("&Foreground Color"),
                     this, SLOT(select_foreground_color()));
  colors->insertItem(klocale->translate("&Background Color"),
                     this, SLOT(select_background_color()));
  m_color->insertSeparator();
  m_color->insertItem(klocale->translate("&Custom Colors"),colors);
  connect(m_color, SIGNAL(activated(int)), SLOT(color_menu_activated(int)));
    
    
  m_options = new QPopupMenu;
//CHECK_PTR( m_options );
//if (menubar_visible)
//  m_options->insertItem( klocale->translate("Hide &Menubar") );
//else
    m_options->insertItem( klocale->translate("Show &Menubar") );
  m_options->insertItem( klocale->translate("Secure &keyboard"));
  m_options->insertSeparator();
//m_options->insertItem( klocale->translate("Scroll&bar"), m_scrollbar);
  m_options->insertItem( klocale->translate("&Font size"), m_size);
  m_options->insertItem( klocale->translate("&Color"), m_color);
//m_options->insertItem( klocale->translate("&Size"), m_dimen);
  m_options->insertItem( klocale->translate("Terminal...") );
  m_options->insertSeparator();
  m_options->insertItem( klocale->translate("Save &Options"));

  m_options->installEventFilter( this );
//connect(m_options, SIGNAL(activated(int)), SLOT(options_menu_activated(int)));

  // create applications ////////////////////////////////////////////////////

//KMenuBar* tst =new KMenuBar(this);
//tst->insertItem("Bla");
//setMenu(tst);

  setCaption(QString("KTerm"));
  setView(te,TRUE);
  setFrameBorderWidth(2);
}

TEDemo::~TEDemo()
{
  delete em;
  delete sh;
//FIXME: delete at?
}

void TEDemo::configureRequest(TEWidget* te, int x, int y)
{
printf("TEDemo::configureRequest(_,%d,%d)\n",x,y);
  m_options->move(te->mapToGlobal(QPoint(x,y)));
  m_options->show();
}

void TEDemo::select_foreground_color()
{
  QColor color(te->getDefaultForeColor());
  
  if(KColorDialog::getColor(color) != QDialog::Accepted)
    return;
  
  te->setDefaultForeColor(color);
}


void TEDemo::select_background_color()
{
  QColor color(te->getDefaultBackColor());
  
  if(KColorDialog::getColor(color) != QDialog::Accepted)
    return;
  
  te->setDefaultBackColor(color);
}

void TEDemo::color_menu_activated(int item)
{
  switch (item)
  {
  case 0: 
    te->setDefaultForeColor(QColor("black"));
    te->setDefaultBackColor(QColor("white"));
    break;
  case 1: 
    te->setDefaultForeColor(QColor("#b2b2b2"));
    te->setDefaultBackColor(QColor("black"));
    break;
  case 2: 
    te->setDefaultForeColor(QColor("#18b218"));
    te->setDefaultBackColor(QColor("black"));
    break;
  case 3: 
    te->setDefaultForeColor(QColor("black"));
    te->setDefaultBackColor(QColor("#FFFFDD"));
    break;
  }
}

/* --| main |---------------------------------------------------------------- */

int main( int argc, char ** argv )
{
  KApplication a(argc, argv, "TEDemo");
  putenv("TERM=xterm"); //FIXME: for mc
  putenv("COLORTERM="); //FIXME: for mc
  QString p = QString("TERMINFO=") + getenv("HOME") + "/.terminfo"; //FIXME: loc
  putenv(p);
  TEDemo m;
  a.setMainWidget( &m );
  m.show();
  return a.exec();
}

#include "main.moc"
