/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [kom.cpp]                     Main Widget                                */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

//FIXME: complete revision nessesary here.

#include <qpainter.h>
#include <qapp.h>
#include <qsocknot.h>
#include <qpopmenu.h>
#include <qlabel.h>
#include <qkeycode.h>
#include <kmsgbox.h>
#include <qtimer.h>
#include <qbttngrp.h>
#include <qfiledlg.h>
#include <qstrlist.h>

#include "kom.h"

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

static FILE* log = NULL;

#include "modem.h"
#include "zmodem.h"
#include "iemsi.h"
#include "iemsi_view.h"
#include "ansiterm.h"
#include "autologin.h"

#include "kom.moc"

#define ESC 27
#define MIN(a,b) ((a)<(b)?(a):(b))
#define MAX(a,b) ((a)>(b)?(a):(b))

#define HERE printf("%s(%d): here\n",__FILE__,__LINE__)

//--| Toolbar |----------------------------------------------------------------

#define TOOL_HELP_ID 6
#define TOOL_STOP_ID 7

void Kom::createToolbar()
{
  QPixmap pixmap;
  QString pmpath;

/*FIXME: other possible usefull material
	QString PIXDIR = "";
	char *kdedir = getenv("KDEDIR");
	if(kdedir)
		PIXDIR.append(kdedir);
	else
		PIXDIR.append("/usr/local/kde");
	PIXDIR.append("/share/toolbar/");

	//printf("Read environemnt\n");

	// Create the toolbar

	QPixmap pixmap;
	pixmap.load(PIXDIR + "back.xpm");
*/

  toolbar = new KToolBar( this );
/*
  pmpath = kapp->findFile( "share/toolbar/dial.xpm" );
  pixmap.load( pmpath );
  toolbar->insertButton(pixmap, TOOL_HELP_ID, SIGNAL( clicked() ),
          this, SLOT( help() ),
          TRUE , "Dial");

  pmpath = kapp->findFile( "share/toolbar/send.xpm" );
  pixmap.load( pmpath );
  toolbar->insertButton(pixmap, TOOL_HELP_ID, SIGNAL( clicked() ),
          this, SLOT( help() ),
          TRUE , "Send File");
*/
  pmpath = kapp->findFile( "share/toolbar/contents.xpm" );
  pixmap.load( pmpath );
  toolbar->insertButton(pixmap, TOOL_HELP_ID, SIGNAL( clicked() ),
          this, SLOT( help() ),
          TRUE , "Help Contents");

  toolbar->insertSeparator();

  pmpath = kapp->findFile( "share/toolbar/stop.xpm" );
  pixmap.load( pmpath );
  toolbar->insertButton(pixmap, TOOL_STOP_ID, SIGNAL( clicked() ),
          this, SLOT( stop() ),
          FALSE, "Stop");

  toolbar->setBarPos( KToolBar::Top );
}

/* --| Kom |--------------------------------------------------------------- */



Kom::Kom( QWidget *parent=0, const char *name=0 ) : KTopLevelWidget(name)
//QWidget(parent,name)
{
  setCaption(QString("Kom: ") + QString(config_get(CONF_BBS_NAME)));
    
  //
  // MENUBAR
  //
  
  m_file = new QPopupMenu;
  m_file->insertItem( "&Send ...", this, SLOT(upload()) );
  m_file->insertSeparator( );
  m_file->insertItem( "&Configure ...",             this, SLOT(open_new()) );
  m_file->insertSeparator( );
  menuLastIemsi =
  m_file->insertItem( "Last &IEMSI Connection ...", this, SLOT(iemsi()) );
  m_file->insertItem( "&About ...", this, SLOT(about()) );
  m_file->insertSeparator( );
  m_file->insertItem( "E&xit",                      qApp, SLOT(quit()) );
    
  m_file->setItemEnabled(menuLastIemsi,FALSE); // activated by IEMSI
 
  //FIXME: qt - no tooltips on the menubar and popup menus???
  menubar = new KMenuBar( this );
  menubar->insertItem( "&File", m_file );
  menubar->insertItem( "&Dial", this, SLOT(dial()));
  menuHangup =
  menubar->insertItem( "&Hangup", this, SLOT(hangup()));
  menubar->setItemEnabled(menuHangup,FALSE);
  menuStop =
  menubar->insertItem( "&Stop", this, SLOT(stop()));
  menubar->setItemEnabled(menuStop,FALSE);
  menubar->insertSeparator();
  menubar->insertItem( "&Help", this, SLOT(help()));
  menubar->setMinimumSize(0,menubar->height());
  menubar->setMaximumSize(10000,menubar->height());

  //
  // IEMSI initiation
  //

  isi = NULL; // no iemsi negotiation yet
  ici = new IemsiClientInfo(); //FIXME: Values!
  ici->user         = QString(config_get(CONF_ID_USERNAME));
  ici->password     = QString(config_get(CONF_ID_PASSWORD));
  ici->location     = QString(config_get(CONF_ID_LOCATION));
  ici->voice_pno    = QString(config_get(CONF_ID_VOICE_NR));
  ici->data_pno     = QString(config_get(CONF_ID_DATA_NR));
  ici->alias        = QString(config_get(CONF_ID_ALIAS));
  ici->birthdate    = 0; // has to become date conversion (if ever)
  // FIXME: this may well be candiates for configuration, too.
  ici->crtdef       = QString("ANSI,24,80,0");
  ici->protocols    = QString("ZMO");
  ici->capabilities = QString("ASCII8");
  ici->requests     = QString("HUSH,CLR,MORE,FSED");
  ici->software     = QString("Kom, Vers. 0.1e-97");
  ici->xlattbl      = QString("");

  log = fopen(config_get(CONF_CAPTURE_FILE),"w");

  mo = new Modem(conv_devices(config_get(CONF_DEVICE)));
  at = new AnsiTerminal(mo,this);
  st = new StatusLine(this);

  QObject::connect( mo, SIGNAL(data_in(int)),
                    this, SLOT(triggerProtocol(int)) );

  QObject::connect( mo, SIGNAL(chgConnect(bool)),
                    st, SLOT(setConnect(bool)) );

  QObject::connect( mo, SIGNAL(chgConnect(bool)),
                    this, SLOT(chgConnect(bool)) );

  this->chgConnect(mo->connected());
  st->setConnect(mo->connected());

  // Drag and drop ////////////////////////////////////////////

  KDNDDropZone * dropZone = new KDNDDropZone( this , DndURL);

  connect( dropZone, SIGNAL( dropAction( KDNDDropZone *) ), 
	   this, SLOT( slotDropEvent( KDNDDropZone *) ) );

  /////////////////////////////////////////////////////////////

  createToolbar();

  setMenu(menubar);
  addToolBar(toolbar);
  setView(at,TRUE); setFrameBorderWidth(2);
  setStatusBar((KStatusBar*)st);

  this->setMinimumSize( at->width()+4,
                        toolbar->height() + menubar->height() +
                        at->height()-4 + st->height()     );

  resize( 10, 10 ); show(); //FIXME: needed by KTopLevelWidget to function

  QTimer::singleShot( 200, this, SLOT(init_1()) );
}


Kom::~Kom()
{
  delete mo;
  if (log) fclose(log);
}

// --| MENU Handler |----------------------------------------------------------

void Kom::open_new()
{
  new Config();
  //FIXME: reconfigure
}

void Kom::about()
//FIXME: make this a little nicer
{
  if
  ( KMsgBox::yesNo
    ( 0, "About Kom", 

      "Kom v" VERSION " - a dial-up serial line terminal\n"
      "\n"
      "Copyright (C) 1997  Lars Doelle\n"
      "email: lars.doelle@on-line.de\n"
      "\n"
      "WARNING: this is early alpha software.\n"
      "\n"
      "This program is free software under the terms of\n"
      "the GNU General Public License and comes WITHOUT\n"
      "ANY WARRANTY. See `Licence for details.",
      KMsgBox::INFORMATION,
      "Close", "Licence"
    ) == 2 )
   kapp->invokeHTMLHelp("kom/gpl.html","");
}

void Kom::help()
{
  kapp->invokeHTMLHelp("kom/index.html","");
}

void Kom::upload()
{
  st->setStatus("Hint: you can drag'n'drop also.");
  QString s = QFileDialog::getOpenFileName( /*dir*/0, "*", this);
  if ( s.isNull() ) return;
printf("selected: %s\n",s.data());
  QString t = "file:"+s;
printf("added: %s\n",t.data());
  QStrList lst;
  lst.append(t);
  sendFiles(&lst);
}

Kom::sendFiles(QStrList* lst)
{
  at->setActive(FALSE);
  Zmodem *zm = new Zmodem(mo);
  QObject::connect( zm,SIGNAL(doneProtocol()), this,SLOT(doneProtocol()));
  QObject::connect( this,SIGNAL(stopProtocol()), zm,SLOT(stopProtocol()));
  QObject::connect
  ( zm, SIGNAL(event(Zmodem::EventType,const char*,long)), 
    st, SLOT(ZmodemEvent(Zmodem::EventType,const char*,long)) );
  zm->startSender(lst);
  st->setStatus("Running ZMODEM protocol.");
  menubar->setItemEnabled(menuStop,TRUE);
  toolbar->setItemEnabled(TOOL_STOP_ID,TRUE);
  menubar->update(); // Fixme: should work with the above
}

// --| Some events |----------------------------------------------------------

void Kom::slotDropEvent( KDNDDropZone * _dropZone )
{
//Fixme: if connected and no protocol running
//Fixme: could eventually add more file while running zmodem.
  QStrList & lst = _dropZone->getURLList();
  Kom::sendFiles(&lst);
}

void Kom::doneProtocol()
{
  at->setActive(TRUE);
  st->setConnect(mo->connected()); // Fixme: return to base status
  menubar->setItemEnabled(menuStop,FALSE);
  toolbar->setItemEnabled(TOOL_STOP_ID,FALSE);
  menubar->update(); // Fixme: should work with the above
}

static int zmod_scan = 0; static char* zmod_trap = "**\030B00";
static int emsi_scan = 0; static char* emsi_trap = "**EMSI";

void Kom::triggerProtocol(int cin)
// "Nobody expects the spanish inquisition!"
// watches for keyword strings suggesting activativation of protocols
// argument: character incoming from modem
{

//Fixme: reset inactivity timer

  if (log) fputc(cin,log);
  if (!at->isActive()) return; // some protocol is allready running


  // ZMODEM ////////////////////////////////////////////////////////////////

  if (zmod_trap[zmod_scan] == cin) zmod_scan++; else zmod_scan = 0;
  if (zmod_trap[zmod_scan] == 0) // START zmodem receiver
  { Zmodem *zm; int i;
    zmod_scan = 0; emsi_scan = 0;
    for (i = 0; i < 5; i++) at->rcv_byte('\b'); // wipe out "**(\030)B00"
    at->setActive(FALSE);
    zm=new Zmodem(mo);
    QObject::connect( zm,SIGNAL(doneProtocol()), this,SLOT(doneProtocol()));
    QObject::connect( this,SIGNAL(stopProtocol()), zm,SLOT(stopProtocol()));
    QObject::connect
    ( zm, SIGNAL(event(Zmodem::EventType,const char*,long)), 
      st, SLOT(ZmodemEvent(Zmodem::EventType,const char*,long)) );
    zm->startReceiver(QString(config_get(CONF_DOWNLOAD_DIR)).data(),zmod_trap);
    st->setStatus("Running ZMODEM protocol.");
    menubar->setItemEnabled(menuStop,TRUE);
    toolbar->setItemEnabled(TOOL_STOP_ID,TRUE);
    menubar->update(); // Fixme: should work with the above
    return;
  }

  // EMSI //////////////////////////////////////////////////////////////////

  if (emsi_trap[emsi_scan] == cin) emsi_scan++; else emsi_scan = 0;
  if (emsi_trap[emsi_scan] == 0) // START iemsi negotiation
  { Iemsi *ie; int i;
    zmod_scan = 0; emsi_scan = 0;
 return;
    for (i = 0; i < 6; i++) at->rcv_byte('\b'); // wipe out "**EMSI"
    at->setActive(FALSE);
    ie = new Iemsi(mo,ici);
    QObject::connect( ie,SIGNAL(doneProtocol()), this,SLOT(doneProtocol()));
    QObject::connect( this,SIGNAL(stopProtocol()), ie,SLOT(stopProtocol()));
    QObject::connect( ie,   SIGNAL(rcv_isi(IemsiServerInfo*)),
                      this, SLOT(rcv_isi(IemsiServerInfo*)) );
    ie->start(emsi_trap);
    st->setStatus("Running IEMSI protocol.");
    menubar->setItemEnabled(menuStop,TRUE);
    toolbar->setItemEnabled(TOOL_STOP_ID,TRUE);
    menubar->update(); // Fixme: should work with the above
    return;
  }
}

void Kom::init_1()
{ char buf[100]; 
  sprintf(buf,"%s/kom/pics/%s",kapp->kde_datadir().data(),config_get(CONF_LOGO));
  st->setStatus("Welcome to Kom v0.3.51. Initializing ...");
  st->setConnect(mo->connected()); // Fixme: return to base status
  FILE*sysin = fopen(buf,"r");
  if (sysin)
  {
    at->rcv_byte('\n');
    while(1)
    {
      int cc = fgetc(sysin);
      if (cc < 0) break;
      at->rcv_byte(cc);
    }
    fclose(sysin);
  }
  QTimer::singleShot(2000, this, SLOT(init_2()) );
}

void Kom::init_2()
{
  st->setConnect(mo->connected()); // Fixme: return to base status
  at->clear(); at->repaint();
//FIXME: start configuration here if appropriate
  mo->send_string(conv_controls(config_get(CONF_INIT_STRING)));
}

    			
void Kom::rcv_isi(IemsiServerInfo* isi)
{
  if (this->isi) delete this->isi;
  this->isi = isi;
  m_file->setItemEnabled(menuLastIemsi,TRUE);
  new IemsiView(isi,1000);
//Fixme: eventually evaluate relevant entries
}

void Kom::iemsi()
{
  new IemsiView(isi,0);
}

void Kom::dial()
{
  mo->send_string(conv_controls(config_get(CONF_DIAL_PREFIX)));
  mo->send_string(              config_get(CONF_DIAL_PHONE ) );
  mo->send_string(conv_controls(config_get(CONF_DIAL_SUFFIX)));
}

void Kom::hangup()
{
  // if (!menubar->isItemEnabled(menuHangup)) return; // Fixme: Qt bug
  mo->hangup();
  if (mo->connected())
    KMsgBox::message
    ( 0, "Hangup failed", 
      "The modem is still connected.\n"
      "\n"
      "Hangup was tried by DTR toggle. If your modem does not\n"
      "have this feature, you must disconnect by other means.\n"
      "\n"
      "You cannot hangup a null modem cable connection, also.\n",
      KMsgBox::EXCLAMATION );
//Fixme: send +++~ATA or whatever to close line.
}

void Kom::stop()
// "Stop it boy!"
// "Wait a second!"
// "Is that the way you treat an expensive musical instrument?"
// (Meat Loaf, Bat out of Hell II)
{
  //Fixme: QT bug, should work without following line.
  // if (!menubar->isItemEnabled(menuStop)) return;
  stopProtocol(); // stop eventual running protocol
  // give line some time to consume garbage
  st->setStatus("stoping ...");
  QTimer::singleShot( 1000, this, SLOT(doneProtocol()) ); // 1 sec
}

void Kom::chgConnect(bool c)
{
  if (c) new Autologin(mo);
  menubar->setItemEnabled(menuHangup,c); // de/activate HANGUP button
  menubar->update(); // Fixme: Qt bug. Delete this line if fixed
}

/* --| main |---------------------------------------------------------------- */

int main( int argc, char ** argv )
{ char buf[100];
    KApplication a(argc, argv, "kom");
    sprintf(buf,"%s/Desktop/Templates/Kom.kom",getenv("HOME"));

    config_init(argc>1?argv[1]:buf);
    Kom m;
    a.setMainWidget( &m );
    m.setGeometry(100,50,0,0);
    m.show();

    return a.exec();
}
