/***************************************************************************
                          logbook.h  -  description                              
                             -------------------                                         
    begin                : Tue May 18 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LOGBOOK_H
#define LOGBOOK_H

#include "logfunc.h"
#include "qso.h"
#include <qlist.h>
//
// Logbuchklasse
// alles fr die Logbuchverwaltung
//---------------------------------

class LogBook
{
private:
	TDInfoBlock dinfo;					// Header fr die Logdatei
	QList<CQso> qsoliste;				// Qsoliste auf QList
	QList<CCall> callliste;				// Call-Liste auf QList
	char logname[MAXFILENAMELENGTH];	// und so heit die Logdatei
	long aktqso;							// aktuelle Qso-Nummer;
	bool changed;							// wurden Eintrge gendert ?
	bool loggeladen;						// wurde ein Log geladen ?
	
	int CompareDatum(CQso* qso1, CQso* qso2);// Datum und UTC vergleichen
	
public:
	LogBook();
	void LogInit(void);
	bool LogLaden(const char *name);
	bool LogSpeichern(const char *name);
	bool LogSchliessen(void);
	void LogSort(long li_grenze,long re_grenze,CQso* tausch);// Qsos nach Datum und Uhrzeit sortieren
	
	bool LoadQsoData(FILE *fh);		// liest alle Qsos ein
	bool LoadCallData(FILE *fh);		// liest alle Calls ein
	bool SaveQsoData(FILE *fh);		// speichert Qsos
	bool SaveCallData(FILE *fh);		// speichert Calls
	bool logChanged(void);				// liefert true zurck, wenn Logbuch gendert wurde
	
	long anzQso(void); 					// Anzahl der gespeicherten Qsos
	long anzCall(void);              // Anzahl der gespeicherten Calls
	long aktQso(void);               // Nummer aktuelles Qso
	bool setAktQso(long nr);			// setzt die aktuelle Qsonummer mit Fehlerprfung
	bool setAktQso(CQso *qso);			// setzt die aktuelle Qsonummer mit Referenz auf qso
	
	CQso* GetQso(long nr);				// liefert Zeiger auf Qso mit der Nummer nr
	bool DeleteQso(long nr);			// lscht Qso mit Nummer nr
	CCall* SearchCall(CQso *qso);		// sucht passende Calldaten zum Qso
	bool AddCall(CCall *call);		   // haengt Call an callliste an...
	bool AddQso(CQso *qso);				// haengt Qso an qsoliste an...
	void GetQsoListe(const char *searchcall,QList<CQso> *liste);	// bildet eine Liste mit allen Qsos von searchcall
	void GetQslOut(QList<CQso> *qsl,int id = QSLOUT_ALL);	// listet alle ausgehenden Qsos nach id auf
	void MarkQslOut(int nr);			// makiert Qsl als aus mit Typ Nr
	CQso *GetQslInList(QList<CQso> *treffer,const char *call,long datum);
};


#endif



























