/***************************************************************************
                          launcher.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Tue Feb 16 1999                                           
    copyright            : (C) 1999 by Didier Gaudin                         
    email                : gaudin@club-internet?fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "launcher.h"
#include <qtimer.h>
#include <kconfig.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qaccel.h>


Launcher::Launcher(QWidget *parent, const char *name) : QDialog(parent, name, TRUE)
{
  setMaximumSize(440,480);
  setMinimumSize(440,480);


  QPushButton * close = new QPushButton(this);
  close -> setGeometry(185,440,70,25);
  close -> setAutoDefault(TRUE);
  close -> setText("Fermer");
  close -> setAccel(Key_Enter);
  close -> setAccel(Key_Return);
  connect(close, SIGNAL(clicked()), SLOT(reject()));

  KConfig *fichier= new KConfig(0L,"xfreeconfig");
/*lancement du serveru X ...... */
  fichier->setGroup("Device");
//  KProcess KProcX  ;
  KProcX<<fichier->readEntry("Server") <<":1.0"<<"-xf86config"<<"/tmp/XF86Config";
/*un timer pour killer le server*/
  QMessageBox::information(this,"Test des nouveaux rglages de X",
                           "X11 va tre lanc pendant 15 secondes, pour vrifier les nouveaux paramtres");
  QTimer * time = new QTimer (this);
  connect(time,SIGNAL (timeout()), SLOT(slotdieX()));
  time->start(15000,TRUE);
/*une multiline edit pour afficher le resultat de l'execution*/
  result = new QMultiLineEdit(this);
  result -> setGeometry(10,10,420,420);
  result -> setReadOnly(TRUE);



/*lancement du processus*/
  KProcX.start(KProcess::DontCare,KProcess::AllOutput );
  connect(&KProcX,SIGNAL(receivedStderr(KProcess *,char *,int)),SLOT(gotData(KProcess *,char *,int)));


  KProcess mire;
  sleep(3);
  mire<<"kmire"<<"-display"<<":1.0";
  mire.start(KProcess::DontCare);
  delete fichier;

}

Launcher::~Launcher(){
}



void Launcher::slotdieX()
{
 KProcX.kill();
}



void Launcher:: gotData(KProcess *,char *data,int len)
{
    if (len<0)
       return;
  static QString remainder;
  QString my_data;
  char dst[len+1];
  qstrncpy(dst,data,len+1);
  my_data.setStr(dst);

  my_data=remainder+my_data;
  QStrList lines=new QStrList;
  int index=0;
  int newindex=0;
while (1)
{
  newindex=my_data.find('\n',index);
  if (newindex==-1) //no more \n's
  {
    remainder=my_data.right(my_data.length()-index);
    break;
  }
  else
  {
    result -> insertLine(my_data.mid(index,newindex-index));
    index=newindex+1;
  }
}

}

