/***************************************************************************
                          avance.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Mon Feb 1 1999                                           
    copyright            : (C) 1999 by                          
    email                :                                      
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include "avance.h"
#include <qfont.h>
#include "info.h"

Avance::Avance(QWidget *parent, const char *name) : QDialog(parent, name, TRUE)
{
  setCaption(klocale->translate("Avanced"));
  setMaximumSize(440,450);
  setMinimumSize(440,450);
  TabW = new KTabCtl(this);
  TabW->setGeometry(0,0,440,410);


  QFont f;
  f.setBold(true);

  graph= new XCarte(this);
  TabW->addTab(graph,klocale->translate("Video Card"));

  entre = new Inputs(this);
  TabW -> addTab (entre,klocale->translate("Inputs"));

  FontWindow = new XFont(this);
  TabW->addTab(FontWindow,klocale->translate("Fonts"));

  dpms = new Dpms(this);
  TabW->addTab(dpms,klocale->translate("DPMS"));

  modeline = new Modeline(this);
  TabW->addTab(modeline,klocale->translate("Modeline"));

  Info * info = new Info(this);
  TabW -> addTab(info,klocale->translate("Info"));

  ok = new QPushButton(this);
  ok->setText(klocale->translate("&Ok"));
  ok->setGeometry(200,420,70,25);
  ok->setFont(f);
  connect(ok, SIGNAL(clicked()), SLOT(slotok()));

  apply = new QPushButton (this);
  apply->setText(klocale->translate("A&pply"));
  apply->setGeometry(280,420,70,25);
  apply->setFont(f);
  connect(apply, SIGNAL(clicked()),SLOT(slotwriteconfig()));

  cancel = new QPushButton(this);
  cancel -> setText(klocale->translate("Cancel"));
  cancel -> setGeometry(360,420,70,25);
  cancel -> setFont(f);
  connect(cancel, SIGNAL(clicked()), SLOT(reject()));

  QPushButton *help = new QPushButton(this);
  help->setText(klocale->translate("Help"));
  help -> setGeometry(10,420,70,25);
  help -> setFont(f);


}
Avance::~Avance(){
}

void Avance::slotok()
{
  writeconfig();
  accept();
}
void Avance::slotwriteconfig()
{
 writeconfig();
}

void Avance::writeconfig()
{
 /*enregistrement des donnees carte graphique*/
 graph->writeconfig();
/*enregistrement des dones souris*/
 entre->writeconfig();
/*enregistrement des fonts*/
 FontWindow->writeconfig();
/*enregistrement du dpms*/
 dpms->writeconfig();
/*enregistrement modeline*/
 modeline->writeconfig();
}




