/*
    kvidtunecfg.cpp - the main view of the KDE VideoTune

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Frithjof Brestrich
                       brestrich@kde.org


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdlib.h> 
#include <unistd.h>

#include <kapp.h>
#include <kconfig.h>

#include <X11/Xlib.h>

#include "kvidtunecfg.h"


KVidTuneCfg::KVidTuneCfg()
{
    char buf[256];

    cfgDisplayWarning         = TRUE;
    cfgNeedConfigInfo         = TRUE;
    cfgConfigFile             = "";
    cfgWorkingDirectory       = "";
    cfgWarnIfNotLocal         = TRUE;
    cfgHideNonActiveModeLines = TRUE;

    gethostname(buf,sizeof(buf)-1);
    hostName                  = buf;

    displayName               = DisplayString(kapp->getDisplay());
}

KVidTuneCfg::~KVidTuneCfg()
{
}

void KVidTuneCfg::configLoad()
{
    char     *home;
    KConfig  *cfg;

    home = getenv("HOME");
    cfg  = kapp->getConfig();

    cfg->setGroup("misc");
    cfgDisplayWarning         = cfg->readNumEntry("displaywarning",TRUE);
    cfgHideNonActiveModeLines = cfg->readNumEntry("hidenonactivemodelines",TRUE);

    cfg->setGroup(hostName + "#" + displayName);
    cfgWarnIfNotLocal   = cfg->readNumEntry("warnifnotlocal",TRUE);
    cfgConfigFile       = cfg->readEntry("configfile","/etc/XF86Config");
    cfgWorkingDirectory = cfg->readEntry("workingdirectory",home?home:".");
}

void KVidTuneCfg::configStore()
{
    KConfig* cfg = kapp->getConfig();
    
    cfg->setGroup("misc");
    cfg->writeEntry("displaywarning",cfgDisplayWarning);
    cfg->writeEntry("hidenonactivemodelines",cfgHideNonActiveModeLines);

    cfg->setGroup(hostName + "#" + displayName);
    cfg->writeEntry("warnifnotlocal",cfgWarnIfNotLocal);
    cfg->writeEntry("configfile",cfgConfigFile);
    cfg->writeEntry("workingdirectory",cfgWorkingDirectory);
    cfg->sync();
}
