/***************************************************************************
    $Id: kpcremovewizard.cpp,v 1.4 1999/10/01 17:42:28 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcremovewizard.cpp,v $
    Revision 1.4  1999/10/01 17:42:28  stephan
    Bughunting.

    Revision 1.3  1999/09/30 20:46:47  wdl
    fixed some things with pointers in kpclib for removeprinter

    Revision 1.2  1999/09/30 17:21:42  stephan
    Makefile fixes.

    Revision 1.1  1999/09/26 15:49:52  stephan
    Added pages for startup and removing.

    Revision 1.2  1999/08/27 16:21:21  wdl
    Standard Headers

 ***************************************************************************/

#include "kpcremovewizard.h"

KpcRemoveWizard::KpcRemoveWizard(QWidget *parent, const char *name ) : QWidget(parent,name) {
	resize(400,400);
	help = new HTMLHelp(this);
	help->setGeometry(10,10,380,190);
	help->showHelp("remove.html");
	printerTree = new KTreeList(this);
	printerTree->setGeometry(10,210,380,140);
	localItem = new KTreeListItem(i18n("Local Printer"));
	netItem = new KTreeListItem(i18n("Network Printers"));
	printerTree->insertItem(localItem);
	printerTree->insertItem(netItem);
	myKpcAPI = new KpcAPI();
	ok_button = new QPushButton(i18n("OK"),this);
	ok_button->setGeometry(10,360,80,25);
	cancel_button = new QPushButton(i18n("Cancel"),this);
	cancel_button->setGeometry(310,360,80,25);
	getInstalledPrinters();
	connect(ok_button,SIGNAL(clicked()),SLOT(SLOTok()));
	connect(cancel_button,SIGNAL(clicked()),SLOT(SLOTcancel()));
	show();
}


KpcRemoveWizard::~KpcRemoveWizard(){
}

void KpcRemoveWizard::SLOTok(){
	KpcPrinter *t_prt = new KpcPrinter();
	QString *t_str = new QString(printerTree->getCurrentItem()->getText());
	QString *t_man_str = new QString;
	QString *t_model_str = new QString;
	*t_man_str = *t_str;
	t_man_str->truncate(t_str->find(" "));
	*t_model_str = *t_str;
	//*t_str = t_model_str->right(t_model_str->find(" ")-1);
	printf("\ndbName(wizard): %s | %s\n",t_model_str->replace(QRegExp(*t_man_str + " "),"").data(),t_man_str->data());
	t_prt->setModel(t_model_str->replace(QRegExp(*t_man_str + " "),"").data());
	t_prt->setDbName(t_model_str->replace(QRegExp(*t_man_str + " "),"").data());
	t_prt->setManufactor(t_man_str->data());
	myKpcAPI->removePrinter(t_prt);
	#warning willy please have a look in here.....
	myKpcAPI->sync(); // if its commented out it works except the printcap entries arent removed....
	//delete(t_prt); delete(t_man_str); delete(t_model_str);
	kapp->quit();
}

void KpcRemoveWizard::SLOTcancel(){
	kapp->quit();
}

void KpcRemoveWizard::getInstalledPrinters(){
	QList<QString> prt_lst;
	QString *t_str = new QString;
	prt_lst = myKpcAPI->getInstalledPrinters(KpcPrinter::local);
	for(t_str = prt_lst.first(); t_str != 0; t_str = prt_lst.next()) {
		localItem->appendChild(new KTreeListItem(t_str->data()));
	}
	prt_lst = myKpcAPI->getInstalledPrinters(KpcPrinter::lpd);
	for(t_str = prt_lst.first(); t_str != 0; t_str = prt_lst.next()) {
		netItem->appendChild(new KTreeListItem(t_str->data()));
	}
	prt_lst = myKpcAPI->getInstalledPrinters(KpcPrinter::smb);
	for(t_str = prt_lst.first(); t_str != 0; t_str = prt_lst.next()) {
		netItem->appendChild(new KTreeListItem(t_str->data()));
	}
}


void KpcRemoveWizard::resizeEvent(QResizeEvent *_revent){
	//printerTree->resize(width()-20,height()-240);
	//help->resize(width()-20,200);
}



